/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.gutenberg;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.DiskGeometry;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.gutenberg.GutenbergFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.List;

public class GutenbergFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int TRACK_LOCATION_INDEX = 0;
    public static final int SECTOR_LOCATION_INDEX = 1;
    public static final int CATALOG_TRACK = 17;
    public static final int VTOC_SECTOR = 7;
    public static final int TRACK_SECTOR_PAIRS = 122;
    private static final String[] filetypes = new String[]{"T"};

    public GutenbergFormatDisk(String filename, ImageOrder imageOrder) {
        super(filename, imageOrder);
    }

    public static GutenbergFormatDisk[] create(String filename, ImageOrder imageOrder) {
        GutenbergFormatDisk disk = new GutenbergFormatDisk(filename, imageOrder);
        disk.format();
        return new GutenbergFormatDisk[]{disk};
    }

    @Override
    public String getFormat() {
        return this.textBundle.get("Gutenberg");
    }

    @Override
    public List<FileEntry> getFiles() {
        ArrayList<FileEntry> list = new ArrayList<FileEntry>();
        int track = 17;
        int sector = 7;
        while (track < 40) {
            byte[] catalogSector = this.readSector(track, sector);
            for (int offset = 16; offset < 255; offset += 16) {
                if (catalogSector[offset] == -96 || track == 17 && (track != 17 || offset <= 16)) continue;
                list.add(new GutenbergFileEntry(this, track, sector, offset));
            }
            track = AppleUtil.getUnsignedByte(catalogSector[4]);
            sector = AppleUtil.getUnsignedByte(catalogSector[5]);
        }
        return list;
    }

    @Override
    public FileEntry createFile() throws DiskFullException {
        byte[] vtoc = this.readVtoc();
        int track = AppleUtil.getUnsignedByte(vtoc[1]);
        int sector = AppleUtil.getUnsignedByte(vtoc[2]);
        while (sector != 0) {
            byte[] catalogSector = this.readSector(track, sector);
            for (int offset = 11; offset < 255; offset += 16) {
                int value = AppleUtil.getUnsignedByte(catalogSector[offset]);
                if (value != 0 && value != 255) continue;
                return new GutenbergFileEntry(this, track, sector, offset);
            }
            track = catalogSector[1];
            sector = catalogSector[2];
        }
        throw new DiskFullException(this.textBundle.get("DosFormatDisk.NoMoreSpaceError"), this.getFilename());
    }

    @Override
    public boolean canCreateDirectories() {
        return false;
    }

    @Override
    public boolean canCreateFile() {
        return false;
    }

    @Override
    public int getFreeSpace() {
        return this.getFreeSectors() * 256;
    }

    public int getFreeSectors() {
        return 0;
    }

    @Override
    public int getUsedSpace() {
        return 143360;
    }

    public int getUsedSectors() {
        return this.getTotalSectors() - this.getFreeSectors();
    }

    public int getTotalSectors() {
        int tracks = this.getTracks();
        int sectors = this.getSectors();
        return tracks * sectors;
    }

    @Override
    public String getDiskName() {
        return AppleUtil.getString(this.readVtoc(), 6, 9).trim();
    }

    protected byte[] readVtoc() {
        return this.readSector(17, 7);
    }

    protected void writeVtoc(byte[] vtoc) {
        this.writeSector(17, 7, vtoc);
    }

    @Override
    public FormattedDisk.DiskUsage getDiskUsage() {
        return new WPDiskUsage();
    }

    public int getTracks() {
        byte[] vtoc = this.readVtoc();
        return AppleUtil.getUnsignedByte(vtoc[52]);
    }

    public int getSectors() {
        byte[] vtoc = this.readVtoc();
        return AppleUtil.getUnsignedByte(vtoc[53]);
    }

    @Override
    public int[] getBitmapDimensions() {
        int tracks = this.getTracks();
        int sectors = this.getSectors();
        return new int[]{tracks, sectors};
    }

    @Override
    public int getBitmapLength() {
        return this.getTotalSectors();
    }

    @Override
    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("DosFormatDisk.Track"), this.textBundle.get("DosFormatDisk.Sector")};
    }

    @Override
    public List<FormattedDisk.DiskInformation> getDiskInformation() {
        List<FormattedDisk.DiskInformation> list = super.getDiskInformation();
        return list;
    }

    @Override
    public List<FormattedDisk.FileColumnHeader> getFileColumnHeaders(int displayMode) {
        ArrayList<FormattedDisk.FileColumnHeader> list = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (displayMode) {
            case 2: {
                list.add(new FormattedDisk.FileColumnHeader(" ", 1, 2, "locked"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.Type"), 1, 2, "type"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3, "sectors"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 30, 1, "name"));
                break;
            }
            case 3: {
                list.add(new FormattedDisk.FileColumnHeader(" ", 1, 2, "locked"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.Type"), 1, 2, "type"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 30, 1, "name"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("SizeInBytes"), 6, 3, "size"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3, "sectors"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2, "deleted"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.TrackAndSectorList"), 7, 2, "trackAndSectorList"));
                break;
            }
            default: {
                list.addAll(super.getFileColumnHeaders(displayMode));
            }
        }
        return list;
    }

    @Override
    public boolean supportsDeletedFiles() {
        return true;
    }

    @Override
    public boolean canReadFileData() {
        return true;
    }

    @Override
    public boolean canWriteFileData() {
        return false;
    }

    @Override
    public boolean canHaveDirectories() {
        return false;
    }

    @Override
    public boolean canDeleteFile() {
        return false;
    }

    @Override
    public byte[] getFileData(FileEntry fileEntry) {
        if (!(fileEntry instanceof GutenbergFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("DosFormatDisk.InvalidFileEntryError"));
        }
        GutenbergFileEntry wpEntry = (GutenbergFileEntry)fileEntry;
        int filesize = wpEntry.getSectorsUsed();
        byte[] fileData = null;
        if (filesize <= 0) {
            fileData = new byte[]{};
            return fileData;
        }
        fileData = new byte[wpEntry.getSectorsUsed() * 256];
        int track = wpEntry.getTrack();
        int sector = wpEntry.getSector();
        int offset = 0;
        while (track < 128) {
            byte[] sectorData = this.readSector(track, sector);
            track = AppleUtil.getUnsignedByte(sectorData[4]);
            sector = AppleUtil.getUnsignedByte(sectorData[5]);
            System.arraycopy(sectorData, 6, fileData, offset, sectorData.length - 6);
            offset += sectorData.length - 6;
        }
        return fileData;
    }

    @Override
    public void setFileData(FileEntry fileEntry, byte[] fileData) throws DiskFullException {
        this.setFileData((GutenbergFileEntry)fileEntry, fileData);
    }

    protected void setFileData(GutenbergFileEntry fileEntry, byte[] data) throws DiskFullException {
        int numberOfDataSectors = (data.length + 256 - 1) / 256;
        int numberOfSectors = numberOfDataSectors + (numberOfDataSectors + 122 - 1) / 122;
        if (numberOfSectors > this.getFreeSectors() + fileEntry.getSectorsUsed()) {
            throw new DiskFullException(this.textBundle.format("DosFormatDisk.NotEnoughSectorsError", numberOfSectors, this.getFreeSectors()), this.getFilename());
        }
        byte[] vtoc = this.readVtoc();
        int track = fileEntry.getTrack();
        int sector = fileEntry.getSector();
        if (track == 0 || track == 255) {
            track = 1;
            sector = 0;
            while (!this.isSectorFree(track, sector, vtoc)) {
                if (++sector < this.getSectors()) continue;
                ++track;
                sector = 0;
            }
            fileEntry.setTrack(track);
            fileEntry.setSector(sector);
        }
        this.setSectorUsed(track, sector, vtoc);
        byte[] trackSectorList = new byte[256];
        int offset = 0;
        int trackSectorOffset = 12;
        int totalSectors = 0;
        int t = 1;
        int s = 0;
        while (offset < data.length) {
            while (!this.isSectorFree(t, s, vtoc)) {
                if (++s < this.getSectors()) continue;
                ++t;
                s = 0;
            }
            this.setSectorUsed(t, s, vtoc);
            if (trackSectorOffset >= 256) {
                trackSectorList[1] = (byte)t;
                trackSectorList[2] = (byte)s;
                this.writeSector(track, sector, trackSectorList);
                trackSectorList = new byte[256];
                trackSectorOffset = 12;
                track = t;
                sector = s;
            } else {
                trackSectorList[trackSectorOffset] = (byte)t;
                trackSectorList[trackSectorOffset + 1] = (byte)s;
                trackSectorOffset += 2;
                byte[] sectorData = new byte[256];
                int length = Math.min(256, data.length - offset);
                System.arraycopy(data, offset, sectorData, 0, length);
                this.writeSector(t, s, sectorData);
                offset += 256;
            }
            ++totalSectors;
        }
        this.writeSector(track, sector, trackSectorList);
        fileEntry.setSectorsUsed(++totalSectors);
        this.writeVtoc(vtoc);
    }

    @Override
    public void format() {
        this.getImageOrder().format();
        this.format(15, 35, 16);
    }

    protected void format(int firstCatalogSector, int tracksPerDisk, int sectorsPerTrack) {
        this.writeBootCode();
        byte[] data = new byte[256];
        for (int sector = firstCatalogSector; sector > 0; --sector) {
            if (sector > 1) {
                data[1] = 17;
                data[2] = (byte)(sector - 1);
            } else {
                data[1] = 0;
                data[2] = 0;
            }
            this.writeSector(17, sector, data);
        }
        data[1] = 17;
        data[2] = (byte)firstCatalogSector;
        data[3] = 3;
        data[6] = -2;
        data[39] = 122;
        data[48] = 18;
        data[49] = 1;
        data[52] = (byte)tracksPerDisk;
        data[53] = (byte)sectorsPerTrack;
        data[55] = 1;
        for (int track = 0; track < tracksPerDisk; ++track) {
            for (int sector = 0; sector < sectorsPerTrack; ++sector) {
                if (track == 0 || track == 17) {
                    this.setSectorUsed(track, sector, data);
                    continue;
                }
                this.setSectorFree(track, sector, data);
            }
        }
        this.writeVtoc(data);
    }

    public boolean isSectorFree(int track, int sector, byte[] vtoc) {
        this.checkRange(track, sector);
        byte byt = vtoc[this.getFreeMapByte(track, sector)];
        return AppleUtil.isBitSet(byt, this.getFreeMapBit(sector));
    }

    public boolean isSectorUsed(int track, int sector, byte[] vtoc) {
        return !this.isSectorFree(track, sector, vtoc);
    }

    public void setSectorFree(int track, int sector, byte[] vtoc) {
        this.checkRange(track, sector);
        int offset = this.getFreeMapByte(track, sector);
        byte byt = vtoc[offset];
        vtoc[offset] = byt = AppleUtil.setBit(byt, this.getFreeMapBit(sector));
    }

    public void setSectorUsed(int track, int sector, byte[] vtoc) {
        this.checkRange(track, sector);
        int offset = this.getFreeMapByte(track, sector);
        byte byt = vtoc[offset];
        vtoc[offset] = byt = AppleUtil.clearBit(byt, this.getFreeMapBit(sector));
    }

    protected int getFreeMapByte(int track, int sector) {
        int trackOffset = track * 4;
        int sectorOffset = 1 - ((sector & 8) >> 3);
        return 56 + trackOffset + sectorOffset;
    }

    protected int getFreeMapBit(int sector) {
        int bit = sector & 7;
        return bit;
    }

    protected void checkRange(int track, int sector) {
        if (track > 50 || sector > 32) {
            throw new IllegalArgumentException(this.textBundle.format("DosFormatDisk.InvalidTrackAndSectorCombinationError", track, sector));
        }
    }

    @Override
    public int getLogicalDiskNumber() {
        return 0;
    }

    @Override
    public String getSuggestedFilename(String filename) {
        int len = Math.min(filename.length(), 12);
        return filename.toUpperCase().substring(0, len).trim();
    }

    @Override
    public String getSuggestedFiletype(String filename) {
        return "T";
    }

    @Override
    public String[] getFiletypes() {
        return filetypes;
    }

    @Override
    public boolean needsAddress(String filetype) {
        return "B".equals(filetype);
    }

    @Override
    public boolean supportsDiskMap() {
        return true;
    }

    @Override
    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByTrackAndSector(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    @Override
    public DirectoryEntry createDirectory(String name) throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    @Override
    public DiskGeometry getDiskGeometry() {
        return DiskGeometry.TRACK_SECTOR;
    }

    private class WPDiskUsage
    implements FormattedDisk.DiskUsage {
        private int[] location = null;

        private WPDiskUsage() {
        }

        @Override
        public boolean hasNext() {
            return this.location == null || this.location[0] < GutenbergFormatDisk.this.getTracks() && this.location[1] < GutenbergFormatDisk.this.getSectors();
        }

        @Override
        public void next() {
            if (this.location == null) {
                this.location = new int[2];
            } else {
                this.location[1] = this.location[1] + 1;
                if (this.location[1] >= GutenbergFormatDisk.this.getSectors()) {
                    this.location[1] = 0;
                    this.location[0] = this.location[0] + 1;
                }
            }
        }

        @Override
        public boolean isFree() {
            if (this.location == null || this.location.length != 2) {
                throw new IllegalArgumentException(StorageBundle.getInstance().get("DosFormatDisk.InvalidDimensionError"));
            }
            return false;
        }

        @Override
        public boolean isUsed() {
            return !this.isFree();
        }
    }
}

