/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.gutenberg;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.GutenbergFileFilter;
import com.webcodepro.applecommander.storage.os.gutenberg.GutenbergFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class GutenbergFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int FILE_DESCRIPTIVE_ENTRY_LENGTH = 16;
    private GutenbergFormatDisk disk;
    private int track;
    private int sector;
    private int offset;

    public GutenbergFileEntry(GutenbergFormatDisk disk, int track, int sector, int offset) {
        this.disk = disk;
        this.track = track;
        this.sector = sector;
        this.offset = offset;
    }

    protected byte[] readFileEntry() {
        byte[] sectorData = this.disk.readSector(this.track, this.sector);
        byte[] fileEntry = new byte[16];
        System.arraycopy(sectorData, this.offset, fileEntry, 0, fileEntry.length);
        return fileEntry;
    }

    protected void writeFileEntry(byte[] fileEntry) {
        if (fileEntry.length != 16) {
            throw new IllegalArgumentException(this.textBundle.format("GutenbergFileEntry.GutenbergFileEntryLengthError", 16));
        }
        byte[] sectorData = this.disk.readSector(this.track, this.sector);
        System.arraycopy(fileEntry, 0, sectorData, this.offset, fileEntry.length);
        this.disk.writeSector(this.track, this.sector, sectorData);
    }

    @Override
    public int getMaximumFilenameLength() {
        return 12;
    }

    @Override
    public String getFilename() {
        return AppleUtil.getString(this.readFileEntry(), 0, this.getMaximumFilenameLength()).trim();
    }

    @Override
    public void setFilename(String filename) {
        byte[] data = this.readFileEntry();
        AppleUtil.setString(data, 0, filename.toUpperCase(), this.getMaximumFilenameLength());
        this.writeFileEntry(data);
    }

    @Override
    public String getFiletype() {
        return "T";
    }

    @Override
    public void setFiletype(String filetype) {
    }

    @Override
    public boolean isLocked() {
        return true;
    }

    @Override
    public void setLocked(boolean lock) {
    }

    @Override
    public int getSize() {
        int size = this.getSectorsUsed() * 256;
        return size;
    }

    public int getSectorsUsed() {
        int track = this.getTrack();
        int sector = this.getSector();
        int sectors = 0;
        while (track < 128) {
            byte[] sectorData = this.disk.readSector(track, sector);
            track = AppleUtil.getUnsignedByte(sectorData[4]);
            sector = AppleUtil.getUnsignedByte(sectorData[5]);
            ++sectors;
        }
        return sectors;
    }

    public void setSectorsUsed(int sectorsUsed) {
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[13]) == 64;
    }

    @Override
    public void delete() {
    }

    @Override
    public List<String> getFileColumnData(int displayMode) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ArrayList<String> list = new ArrayList<String>();
        switch (displayMode) {
            case 2: {
                list.add(this.isLocked() ? "*" : " ");
                list.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getSectorsUsed()));
                list.add(this.getFilename());
                break;
            }
            case 3: {
                list.add(this.isLocked() ? "*" : " ");
                list.add(this.getFiletype());
                list.add(this.getFilename());
                list.add(numberFormat.format(this.getSize()));
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getSectorsUsed()));
                list.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                list.add("T" + this.getTrack() + " S" + this.getSector());
                break;
            }
            default: {
                list.add(this.getFilename());
                list.add(this.getFiletype());
                list.add(numberFormat.format(this.getSize()));
                list.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return list;
    }

    public int getTrack() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[12]);
    }

    public void setTrack(int track) {
        byte[] data = this.readFileEntry();
        data[12] = (byte)track;
        this.writeFileEntry(data);
    }

    public int getSector() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[13]);
    }

    public void setSector(int sector) {
        byte[] data = this.readFileEntry();
        data[13] = (byte)sector;
        this.writeFileEntry(data);
    }

    @Override
    public byte[] getFileData() {
        return this.disk.getFileData(this);
    }

    @Override
    public void setFileData(byte[] data) throws DiskFullException {
        this.disk.setFileData(this, data);
    }

    @Override
    public FileFilter getSuggestedFilter() {
        return new GutenbergFileFilter();
    }

    public boolean isAssemblySourceFile() {
        return false;
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    @Override
    public boolean needsAddress() {
        return false;
    }

    @Override
    public void setAddress(int address) {
    }

    @Override
    public int getAddress() {
        return 0;
    }

    @Override
    public boolean canCompile() {
        return false;
    }
}

