/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.dos33;

import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.TextBundle;

public class UniDosFormatDisk
extends DosFormatDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int UNIDOS_DISK_1 = 0;
    public static final int UNIDOS_DISK_2 = 50;
    private int logicalOffset;

    public UniDosFormatDisk(String filename, ImageOrder imageOrder, int logicalOffset) {
        super(filename, imageOrder);
        this.logicalOffset = logicalOffset;
    }

    public static DosFormatDisk[] create(String filename, ImageOrder imageOrder) {
        UniDosFormatDisk disk1 = new UniDosFormatDisk(filename, imageOrder, 0);
        UniDosFormatDisk disk2 = new UniDosFormatDisk(filename, imageOrder, 50);
        disk1.format();
        disk2.format();
        return new UniDosFormatDisk[]{disk1, disk2};
    }

    @Override
    public String getDiskName() {
        if (this.logicalOffset == 0) {
            return this.textBundle.format("DiskNameN", super.getDiskName(), 1);
        }
        if (this.logicalOffset == 50) {
            return this.textBundle.format("DiskNameN", super.getDiskName(), 2);
        }
        return super.getDiskName();
    }

    @Override
    public int getLogicalDiskNumber() {
        if (this.logicalOffset == 0) {
            return 1;
        }
        if (this.logicalOffset == 50) {
            return 2;
        }
        return 0;
    }

    @Override
    public void format() {
        int tracksPerDisk = 50;
        int sectorsPerTrack = 32;
        int firstCatalogSector = 31;
        byte[] data = new byte[256];
        for (int t = 0; t < 50; ++t) {
            for (int s = 0; s < 32; ++s) {
                this.writeSector(t, s, data);
            }
        }
        this.format(31, 50, 32);
    }

    @Override
    public byte[] readSector(int track, int sector) throws IllegalArgumentException {
        return this.getImageOrder().readSector(track + this.logicalOffset, sector);
    }

    @Override
    public void writeSector(int track, int sector, byte[] bytes) throws IllegalArgumentException {
        this.getImageOrder().writeSector(track + this.logicalOffset, sector, bytes);
    }
}

