/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.dos33;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.ApplesoftFileFilter;
import com.webcodepro.applecommander.storage.filters.AssemblySourceFileFilter;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.IntegerBasicFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class DosFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int FILE_DESCRIPTIVE_ENTRY_LENGTH = 35;
    private DosFormatDisk disk;
    private int track;
    private int sector;
    private int offset;
    private Integer address;

    public DosFileEntry(DosFormatDisk disk, int track, int sector, int offset) {
        this.disk = disk;
        this.track = track;
        this.sector = sector;
        this.offset = offset;
    }

    protected byte[] readFileEntry() {
        byte[] sectorData = this.disk.readSector(this.track, this.sector);
        byte[] fileEntry = new byte[35];
        System.arraycopy(sectorData, this.offset, fileEntry, 0, fileEntry.length);
        return fileEntry;
    }

    protected void writeFileEntry(byte[] fileEntry) {
        if (fileEntry.length != 35) {
            throw new IllegalArgumentException(this.textBundle.format("DosFileEntry.DosFileEntryLengthError", 35));
        }
        byte[] sectorData = this.disk.readSector(this.track, this.sector);
        System.arraycopy(fileEntry, 0, sectorData, this.offset, fileEntry.length);
        this.disk.writeSector(this.track, this.sector, sectorData);
    }

    @Override
    public int getMaximumFilenameLength() {
        return 30;
    }

    @Override
    public String getFilename() {
        return AppleUtil.getString(this.readFileEntry(), 3, 30).trim();
    }

    @Override
    public void setFilename(String filename) {
        byte[] data = this.readFileEntry();
        AppleUtil.setString(data, 3, filename.toUpperCase(), 30);
        this.writeFileEntry(data);
    }

    @Override
    public String getFiletype() {
        int filetype = AppleUtil.getUnsignedByte(this.readFileEntry()[2]) & 0x7F;
        if (filetype == 0) {
            return "T";
        }
        if ((filetype ^ 1) == 0) {
            return "I";
        }
        if ((filetype ^ 2) == 0) {
            return "A";
        }
        if ((filetype ^ 4) == 0) {
            return "B";
        }
        if ((filetype ^ 8) == 0) {
            return "S";
        }
        if ((filetype ^ 0x10) == 0) {
            return "R";
        }
        if ((filetype ^ 0x20) == 0) {
            return "a";
        }
        if ((filetype ^ 0x40) == 0) {
            return "b";
        }
        return "?";
    }

    @Override
    public void setFiletype(String filetype) {
        byte[] data = this.readFileEntry();
        int type = 4;
        if ("T".equals(filetype) || "TXT".equals(filetype)) {
            type = 0;
        }
        if ("I".equals(filetype)) {
            type = 1;
        }
        if ("A".equals(filetype) || "BAS".equals(filetype)) {
            type = 2;
        }
        if ("B".equals(filetype)) {
            type = 4;
        }
        if ("S".equals(filetype)) {
            type = 8;
        }
        if ("R".equals(filetype)) {
            type = 16;
        }
        if ("a".equals(filetype)) {
            type = 32;
        }
        if ("b".equals(filetype)) {
            type = 64;
        }
        data[2] = (byte)(type |= data[2] & 0x80);
        this.writeFileEntry(data);
    }

    @Override
    public boolean isLocked() {
        return (this.readFileEntry()[2] & 0x80) != 0;
    }

    @Override
    public void setLocked(boolean lock) {
        byte[] data = this.readFileEntry();
        data[2] = lock ? (byte)(AppleUtil.getUnsignedByte(data[2]) | 0x80) : (byte)(AppleUtil.getUnsignedByte(data[2]) & 0x7F);
        this.writeFileEntry(data);
    }

    @Override
    public int getSize() {
        int size;
        byte[] rawdata = null;
        if (!this.isDeleted()) {
            rawdata = this.disk.getFileData(this);
        }
        if ((size = (this.getSectorsUsed() - 1) * 256) < 1) {
            size = 0;
        }
        if (rawdata != null) {
            if ("B".equals(this.getFiletype())) {
                return AppleUtil.getWordValue(rawdata, 2);
            }
            if ("A".equals(this.getFiletype()) || "I".equals(this.getFiletype())) {
                return AppleUtil.getWordValue(rawdata, 0);
            }
        }
        return size;
    }

    public int getSectorsUsed() {
        return AppleUtil.getWordValue(this.readFileEntry(), 33);
    }

    public void setSectorsUsed(int sectorsUsed) {
        byte[] data = this.readFileEntry();
        AppleUtil.setWordValue(data, 33, sectorsUsed);
        this.writeFileEntry(data);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[0]) == 255;
    }

    @Override
    public void delete() {
        this.disk.freeSectors(this);
        byte[] fileEntry = this.readFileEntry();
        fileEntry[32] = fileEntry[0];
        fileEntry[0] = -1;
        this.writeFileEntry(fileEntry);
    }

    @Override
    public List<String> getFileColumnData(int displayMode) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ArrayList<String> list = new ArrayList<String>();
        switch (displayMode) {
            case 2: {
                list.add(this.isLocked() ? "*" : " ");
                list.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getSectorsUsed()));
                list.add(this.getFilename());
                break;
            }
            case 3: {
                list.add(this.isLocked() ? "*" : " ");
                list.add(this.getFiletype());
                list.add(this.getFilename());
                list.add(numberFormat.format(this.getSize()));
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getSectorsUsed()));
                list.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                list.add("T" + this.getTrack() + " S" + this.getSector());
                list.add("A=$" + AppleUtil.getFormattedWord(this.getAddress()));
                break;
            }
            default: {
                list.add(this.getFilename());
                list.add(this.getFiletype());
                list.add(numberFormat.format(this.getSize()));
                list.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return list;
    }

    public int getTrack() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[0]);
    }

    public void setTrack(int track) {
        byte[] data = this.readFileEntry();
        data[0] = (byte)track;
        this.writeFileEntry(data);
    }

    public int getSector() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[1]);
    }

    public void setSector(int sector) {
        byte[] data = this.readFileEntry();
        data[1] = (byte)sector;
        this.writeFileEntry(data);
    }

    @Override
    public byte[] getFileData() {
        byte[] filedata;
        byte[] rawdata = this.disk.getFileData(this);
        if (this.isBinaryFile()) {
            int length = AppleUtil.getWordValue(rawdata, 2);
            filedata = new byte[length];
            System.arraycopy(rawdata, 4, filedata, 0, length);
        } else if (this.isApplesoftBasicFile() || this.isIntegerBasicFile()) {
            filedata = new byte[this.getSize()];
            System.arraycopy(rawdata, 2, filedata, 0, filedata.length);
        } else {
            filedata = rawdata;
        }
        return filedata;
    }

    @Override
    public void setFileData(byte[] data) throws DiskFullException {
        if (this.isBinaryFile()) {
            byte[] filedata = new byte[data.length + 4];
            if (this.address != null) {
                AppleUtil.setWordValue(filedata, 0, this.address);
                this.address = null;
            } else {
                AppleUtil.setWordValue(filedata, 0, 0);
            }
            AppleUtil.setWordValue(filedata, 2, data.length);
            System.arraycopy(data, 0, filedata, 4, data.length);
            this.disk.setFileData(this, filedata);
        } else if (this.isApplesoftBasicFile() || this.isIntegerBasicFile()) {
            byte[] filedata = new byte[data.length + 2];
            AppleUtil.setWordValue(filedata, 0, data.length);
            System.arraycopy(data, 0, filedata, 2, data.length);
            this.disk.setFileData(this, filedata);
        } else if (this.isTextFile()) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] | 0x80);
            }
            this.disk.setFileData(this, data);
        } else {
            this.disk.setFileData(this, data);
        }
    }

    @Override
    public FileFilter getSuggestedFilter() {
        if (this.isApplesoftBasicFile()) {
            return new ApplesoftFileFilter();
        }
        if (this.isIntegerBasicFile()) {
            return new IntegerBasicFileFilter();
        }
        if (this.isAssemblySourceFile()) {
            return new AssemblySourceFileFilter();
        }
        if (this.isTextFile()) {
            return new TextFileFilter();
        }
        if (this.isBinaryFile()) {
            int size = this.getSize();
            GraphicsFileFilter filter = new GraphicsFileFilter();
            if (size >= 8184 && size <= 8192) {
                filter.setMode(2);
                return filter;
            }
            if (size >= 16377 && size <= 16384) {
                filter.setMode(4);
                return filter;
            }
        }
        return new BinaryFileFilter();
    }

    public boolean isAssemblySourceFile() {
        boolean rightFiletype;
        boolean bl = rightFiletype = this.isTextFile() || this.isBinaryFile();
        if (rightFiletype && this.getFilename().endsWith(".S")) {
            return true;
        }
        return rightFiletype && this.getFilename().startsWith("T.");
    }

    public boolean isTextFile() {
        return "T".equals(this.getFiletype());
    }

    public boolean isApplesoftBasicFile() {
        return "A".equals(this.getFiletype());
    }

    public boolean isIntegerBasicFile() {
        return "I".equals(this.getFiletype());
    }

    public boolean isBinaryFile() {
        return "B".equals(this.getFiletype());
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    @Override
    public boolean needsAddress() {
        return this.disk.needsAddress(this.getFiletype());
    }

    @Override
    public void setAddress(int address) {
        try {
            byte[] rawdata = this.disk.getFileData(this);
            if (rawdata == null || rawdata.length == 0) {
                this.address = address;
            } else {
                AppleUtil.setWordValue(rawdata, 0, address);
                this.disk.setFileData(this, rawdata);
            }
        }
        catch (DiskFullException e) {
            throw new IllegalStateException(this.textBundle.format("DosFileEntry.UnableToSetAddressError", this.getFilename()));
        }
    }

    @Override
    public int getAddress() {
        if (this.needsAddress()) {
            byte[] rawData = this.disk.getFileData(this);
            return AppleUtil.getWordValue(rawData, 0);
        }
        return 0;
    }

    @Override
    public boolean canCompile() {
        return this.isApplesoftBasicFile();
    }
}

