/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.cpm;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.DiskGeometry;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.cpm.CpmFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class CpmFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int CPM_SECTORSIZE = 128;
    public static final int CPM_BLOCKSIZE = 1024;
    public static final int CPM_SECTORS_PER_CPM_BLOCK = 8;
    public static final int CPM_BLOCKS_PER_TRACK = 4;
    public static final int PHYSICAL_SECTORS_PER_BLOCK = 4;
    public static final int PHYSICAL_BLOCK_TRACK_START = 3;
    public static final int[] sectorSkew = new int[]{0, 6, 12, 3, 9, 15, 14, 5, 11, 2, 8, 7, 13, 4, 10, 1};

    public CpmFormatDisk(String filename, ImageOrder imageOrder) {
        super(filename, imageOrder);
    }

    public static CpmFormatDisk[] create(String filename, ImageOrder imageOrder) {
        CpmFormatDisk disk = new CpmFormatDisk(filename, imageOrder);
        disk.format();
        return new CpmFormatDisk[]{disk};
    }

    @Override
    public String getDiskName() {
        return this.textBundle.get("CpmFormatDisk.DiskName");
    }

    @Override
    public String getFormat() {
        return this.textBundle.get("CpmFormatDisk.Cpm");
    }

    @Override
    public int getFreeSpace() {
        return this.getPhysicalSize() - this.getUsedSpace();
    }

    @Override
    public int getUsedSpace() {
        int blocksUsed = this.getBlocksUsed();
        return blocksUsed * 1024 + 12288;
    }

    public int getBlocksUsed() {
        List<FileEntry> files = this.getFiles();
        int blocksUsed = 0;
        for (int i = 0; i < files.size(); ++i) {
            CpmFileEntry fileEntry = (CpmFileEntry)files.get(i);
            blocksUsed = fileEntry.getBlocksUsed();
        }
        return blocksUsed;
    }

    @Override
    public int[] getBitmapDimensions() {
        return null;
    }

    @Override
    public int getBitmapLength() {
        return this.getPhysicalSize() / 1024;
    }

    @Override
    public FormattedDisk.DiskUsage getDiskUsage() {
        boolean[] usage = new boolean[this.getBitmapLength()];
        int dataBlockStart = 12;
        for (int i = 0; i < dataBlockStart + 2; ++i) {
            usage[i] = true;
        }
        List<FileEntry> files = this.getFiles();
        for (int i = 0; i < files.size(); ++i) {
            CpmFileEntry fileEntry = (CpmFileEntry)files.get(i);
            int[] allocation = fileEntry.getAllocations();
            for (int a = 0; a < allocation.length; ++a) {
                int block = dataBlockStart + allocation[a];
                usage[block] = true;
            }
        }
        return new CpmDiskUsage(usage);
    }

    @Override
    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("CpmFormatDisk.BitmapLabel")};
    }

    @Override
    public boolean supportsDeletedFiles() {
        return true;
    }

    @Override
    public boolean canReadFileData() {
        return true;
    }

    @Override
    public boolean canWriteFileData() {
        return false;
    }

    @Override
    public boolean canHaveDirectories() {
        return false;
    }

    @Override
    public boolean canDeleteFile() {
        return true;
    }

    @Override
    public byte[] getFileData(FileEntry fileEntry) {
        CpmFileEntry cpmEntry = (CpmFileEntry)fileEntry;
        int[] allocations = cpmEntry.getAllocations();
        byte[] data = new byte[allocations.length * 1024];
        for (int i = 0; i < allocations.length; ++i) {
            int blockNumber = allocations[i];
            if (blockNumber <= 0) continue;
            byte[] block = this.readCpmBlock(blockNumber);
            System.arraycopy(block, 0, data, i * 1024, 1024);
        }
        return data;
    }

    @Override
    public void format() {
        this.getImageOrder().format();
        byte[] sectorData = new byte[256];
        for (int i = 0; i < 256; ++i) {
            sectorData[i] = -27;
        }
        for (int track = 0; track < 35; ++track) {
            for (int sector = 0; sector < 16; ++sector) {
                this.writeSector(track, sector, sectorData);
            }
        }
    }

    @Override
    public int getLogicalDiskNumber() {
        return 0;
    }

    @Override
    public String getSuggestedFilename(String filename) {
        StringTokenizer tokenizer = new StringTokenizer(filename, ".");
        filename = tokenizer.nextToken();
        StringBuffer newName = new StringBuffer();
        if (!Character.isLetter(filename.charAt(0))) {
            newName.append('A');
        }
        for (int i = 0; newName.length() < 8 && i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '.') continue;
            newName.append(ch);
        }
        while (newName.length() < 8) {
            newName.append(' ');
        }
        return newName.toString().toUpperCase().trim();
    }

    @Override
    public String getSuggestedFiletype(String filetype) {
        StringTokenizer tokenizer = new StringTokenizer(filetype, ".");
        tokenizer.nextToken();
        filetype = "";
        while (tokenizer.hasMoreTokens()) {
            filetype = tokenizer.nextToken();
        }
        StringBuffer newType = new StringBuffer();
        if (filetype.length() > 0 && !Character.isLetter(filetype.charAt(0))) {
            newType.append('A');
        }
        for (int i = 0; newType.length() < 3 && i < filetype.length(); ++i) {
            char ch = filetype.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '.') continue;
            newType.append(ch);
        }
        while (newType.length() < 3) {
            newType.append(' ');
        }
        return newType.toString().toUpperCase().trim();
    }

    @Override
    public String[] getFiletypes() {
        return null;
    }

    @Override
    public boolean needsAddress(String filetype) {
        return false;
    }

    @Override
    public List<FileEntry> getFiles() {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        HashMap<CallSite, CpmFileEntry> index = new HashMap<CallSite, CpmFileEntry>();
        for (int i = 0; i < 64; ++i) {
            int offset = i * 32;
            CpmFileEntry fileEntry = new CpmFileEntry(this, offset);
            if (fileEntry.isEmpty()) continue;
            String key = fileEntry.getFilename().trim() + "." + fileEntry.getFiletype().trim() + ":" + fileEntry.getUserNumber(0);
            if (index.containsKey(key)) {
                fileEntry = (CpmFileEntry)index.get(key);
                fileEntry.addOffset(offset);
                continue;
            }
            files.add(fileEntry);
            index.put((CallSite)((Object)key), fileEntry);
        }
        return files;
    }

    @Override
    public FileEntry createFile() throws DiskFullException {
        throw new DiskFullException(this.textBundle.get("FileCreationNotSupported"), this.getFilename());
    }

    @Override
    public boolean canCreateDirectories() {
        return false;
    }

    @Override
    public boolean canCreateFile() {
        return false;
    }

    public byte[] readCpmBlock(int block) {
        byte[] data = new byte[1024];
        int track = this.computeTrack(block);
        int sector = this.computeSector(block);
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(this.readSector(track, sectorSkew[sector + i]), 0, data, i * 256, 256);
        }
        return data;
    }

    public byte[] readCpmFileEntries() {
        byte[] data = new byte[2048];
        System.arraycopy(this.readCpmBlock(0), 0, data, 0, 1024);
        System.arraycopy(this.readCpmBlock(1), 0, data, 1024, 1024);
        return data;
    }

    public void writeCpmFileEntries(byte[] data) {
        byte[] block = new byte[1024];
        System.arraycopy(data, 0, block, 0, 1024);
        this.writeCpmBlock(0, block);
        System.arraycopy(data, 1024, block, 0, 1024);
        this.writeCpmBlock(1, block);
    }

    protected int computeTrack(int block) {
        return 3 + block / 4;
    }

    protected int computeSector(int block) {
        return block % 4 * 4;
    }

    public void writeCpmBlock(int block, byte[] data) {
        int track = this.computeTrack(block);
        int sector = this.computeSector(block);
        byte[] sectorData = new byte[256];
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(data, i * 256, sectorData, 0, 256);
            this.writeSector(track, sectorSkew[sector + i], sectorData);
        }
    }

    @Override
    public List<FormattedDisk.FileColumnHeader> getFileColumnHeaders(int displayMode) {
        ArrayList<FormattedDisk.FileColumnHeader> list = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (displayMode) {
            case 2: {
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 8, 1, "name"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Type"), 3, 1, "type"));
                break;
            }
            case 3: {
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 8, 1, "name"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Type"), 3, 1, "type"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("SizeInBytes"), 6, 3, "sizeInBytes"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("CpmFormatDisk.UserNumber"), 4, 3, "user"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2, "deleted"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("LockedQ"), 6, 2, "locked"));
                break;
            }
            default: {
                list.addAll(super.getFileColumnHeaders(displayMode));
            }
        }
        return list;
    }

    @Override
    public boolean supportsDiskMap() {
        return true;
    }

    @Override
    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByTrackAndSector(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    @Override
    public void setFileData(FileEntry fileEntry, byte[] fileData) throws DiskFullException {
    }

    @Override
    public DirectoryEntry createDirectory(String name) throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    @Override
    public DiskGeometry getDiskGeometry() {
        return DiskGeometry.TRACK_SECTOR;
    }

    public class CpmDiskUsage
    implements FormattedDisk.DiskUsage {
        int block = -1;
        boolean[] usage = null;

        public CpmDiskUsage(boolean[] usage) {
            this.usage = usage;
        }

        @Override
        public boolean hasNext() {
            return this.block < this.usage.length - 1;
        }

        @Override
        public void next() {
            ++this.block;
        }

        @Override
        public boolean isFree() {
            return !this.isUsed();
        }

        @Override
        public boolean isUsed() {
            return this.usage[this.block];
        }
    }
}

