/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.ui.AppleCommander;
import com.webcodepro.applecommander.util.AppleUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AppleWorksWordProcessorFileFilter
implements FileFilter {
    private static final int RENDER_AS_TEXT = 0;
    private static final int RENDER_AS_HTML = 1;
    private static final int RENDER_AS_RTF = 2;
    private int rendering = 0;
    private boolean inHeaderOrFooter = false;
    private static final int TWIPS_PER_INCH = 1440;
    private static final int CODE_BOLD_ON = 1;
    private static final int CODE_BOLD_OFF = 2;
    private static final int CODE_SUPERSCRIPT_ON = 3;
    private static final int CODE_SUPERSCRIPT_OFF = 4;
    private static final int CODE_SUBSCRIPT_ON = 5;
    private static final int CODE_SUBSCRIPT_OFF = 6;
    private static final int CODE_UNDERLINE_ON = 7;
    private static final int CODE_UNDERLINE_OFF = 8;
    private static final int CODE_PAGE_NUMBER = 9;
    private static final int CODE_STICKY_SPACE = 11;
    private static final int CODE_DATE = 14;
    private static final int CODE_TIME = 15;
    private static final int COMMAND_PAGEHEADER_END = 213;
    private static final int COMMAND_PAGEFOOTER_END = 214;
    private static final int COMMAND_RIGHT = 215;
    private static final int COMMAND_PLATEN_WIDTH = 216;
    private static final int COMMAND_MARGIN_LEFT = 217;
    private static final int COMMAND_MARGIN_RIGHT = 218;
    private static final int COMMAND_JUSTIFY = 223;
    private static final int COMMAND_LEFT = 224;
    private static final int COMMAND_CENTER = 225;
    private static final int COMMAND_PAPER_LENGTH = 226;
    private static final int COMMAND_MARGIN_TOP = 227;
    private static final int COMMAND_MARGIN_BOTTOM = 228;
    private static final int COMMAND_NEW_PAGE = 233;
    private static final int COMMAND_PAGEHEADER = 237;
    private static final int COMMAND_PAGEFOOTER = 236;
    private static final int COMMAND_SKIP_LINES = 238;
    private static final int COMMAND_PAGE_BREAK = 244;
    private static final int COMMAND_PAGE_BREAK_256 = 245;
    private static final int COMMAND_EOF = 255;

    @Override
    public byte[] filter(FileEntry fileEntry) {
        byte[] fileData = fileEntry.getFileData();
        if (fileData[4] != 79) {
            return null;
        }
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(fileData.length);
        PrintWriter printWriter = new PrintWriter(byteArray, true);
        if (this.isHtmlRendering()) {
            printWriter.println("<html><style>BODY { font-family: monospace; }</style><body>");
        } else if (this.isRtfRendering()) {
            printWriter.print("{\\rtf1");
            printWriter.print("{\\fonttbl{\\f0\\fmodern\\fprq1\\fcharset0 Courier New;}}");
            printWriter.print("{\\*\\generator AppleCommander ");
            printWriter.print(AppleCommander.VERSION);
            printWriter.println(";}");
            printWriter.print("\\f0 ");
        }
        boolean version3 = fileData[183] != 0;
        int offset = 300 + (version3 ? 2 : 0);
        while (offset < fileData.length) {
            int byte0 = AppleUtil.getUnsignedByte(fileData[offset++]);
            int byte1 = AppleUtil.getUnsignedByte(fileData[offset++]);
            if (byte0 == 255 && byte1 == 255) break;
            if (byte1 == 208) {
                this.handleReturn(printWriter);
                continue;
            }
            if (byte1 > 208) {
                if (this.isHtmlRendering()) {
                    offset = this.handleCommandRecordAsHtml(byte0, byte1, printWriter, offset);
                    continue;
                }
                if (this.isRtfRendering()) {
                    offset = this.handleCommandRecordAsRtf(byte0, byte1, printWriter, offset);
                    continue;
                }
                offset = this.handleCommandRecordAsText(byte0, byte1, printWriter, offset);
                continue;
            }
            offset = this.handleTextRecord(fileData, printWriter, offset);
        }
        if (this.isHtmlRendering()) {
            printWriter.println("</body></html>");
        } else if (this.isRtfRendering()) {
            printWriter.println("}");
        }
        return byteArray.toByteArray();
    }

    protected int handleTextRecord(byte[] fileData, PrintWriter printWriter, int offset) {
        AppleUtil.getUnsignedByte(fileData[offset++]);
        int byte3 = AppleUtil.getUnsignedByte(fileData[offset++]);
        boolean addReturn = byte3 >= 128;
        int length = byte3 & 0x7F;
        while (length > 0 && offset < fileData.length) {
            byte ch = fileData[offset++];
            --length;
            if (ch < 32) {
                if (this.isHtmlRendering()) {
                    this.handleSpecialCodesAsHtml(printWriter, ch);
                    continue;
                }
                if (this.isRtfRendering()) {
                    this.handleSpecialCodesAsRtf(printWriter, ch);
                    continue;
                }
                this.handleSpecialCodesAsText(printWriter, ch);
                continue;
            }
            if (this.isHtmlRendering() && ch == 32) {
                int extraSpaces = 0;
                while (fileData[offset + extraSpaces] == 32) {
                    ++extraSpaces;
                }
                if (extraSpaces > 0) {
                    printWriter.print("&nbsp;");
                    while (fileData[offset] == 32) {
                        ++offset;
                        --length;
                        printWriter.print("&nbsp;");
                    }
                    continue;
                }
                printWriter.print((char)ch);
                continue;
            }
            printWriter.print((char)ch);
        }
        if (addReturn) {
            this.handleReturn(printWriter);
        }
        return offset;
    }

    protected void handleReturn(PrintWriter printWriter) {
        if (this.isHtmlRendering()) {
            printWriter.println("<br>");
        } else if (this.isRtfRendering()) {
            printWriter.println("\\par");
        } else {
            printWriter.println();
        }
    }

    protected void handleSpecialCodesAsHtml(PrintWriter printWriter, byte ch) {
        switch (ch) {
            case 1: {
                printWriter.print("<b>");
                break;
            }
            case 2: {
                printWriter.print("</b>");
                break;
            }
            case 3: {
                printWriter.print("<sup>");
                break;
            }
            case 4: {
                printWriter.print("</sup>");
                break;
            }
            case 5: {
                printWriter.print("<sub>");
                break;
            }
            case 6: {
                printWriter.print("</sub>");
                break;
            }
            case 7: {
                printWriter.print("<u>");
                break;
            }
            case 8: {
                printWriter.print("</u>");
                break;
            }
            case 11: {
                printWriter.print("&nbsp;");
                break;
            }
            default: {
                this.handleSpecialCodesAsText(printWriter, ch);
            }
        }
    }

    protected void handleSpecialCodesAsRtf(PrintWriter printWriter, byte ch) {
        switch (ch) {
            case 9: {
                printWriter.print("{\\chpgn}");
                break;
            }
            case 1: {
                printWriter.print("\\b ");
                break;
            }
            case 2: {
                printWriter.print("\\b0 ");
                break;
            }
            case 7: {
                printWriter.print("\\ul ");
                break;
            }
            case 8: {
                printWriter.print("\\ulnone");
                break;
            }
            case 3: {
                printWriter.print("\\super ");
                break;
            }
            case 5: {
                printWriter.print("\\sub ");
                break;
            }
            case 4: 
            case 6: {
                printWriter.print("\\nosupersub ");
                break;
            }
            case 11: {
                printWriter.print(" ");
                break;
            }
            default: {
                this.handleSpecialCodesAsText(printWriter, ch);
            }
        }
    }

    protected void handleSpecialCodesAsText(PrintWriter printWriter, byte ch) {
        switch (ch) {
            case 9: {
                printWriter.print("[Page#]");
                break;
            }
            case 14: {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy");
                printWriter.print(dateFormat.format(new Date()));
                break;
            }
            case 15: {
                SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
                printWriter.print(timeFormat.format(new Date()));
            }
        }
    }

    protected int handleCommandRecordAsHtml(int byte0, int byte1, PrintWriter printWriter, int offset) {
        switch (byte1) {
            case 215: {
                printWriter.println("<style>BODY: text-align: right;</style>");
                break;
            }
            case 223: {
                printWriter.println("<style>BODY: text-align: justify;</style>");
                break;
            }
            case 224: {
                printWriter.println("<style>BODY: text-align: left;</style>");
                break;
            }
            case 225: {
                printWriter.println("<style>BODY: text-align: center;</style>");
                break;
            }
            default: {
                offset = this.handleCommandRecordAsText(byte0, byte1, printWriter, offset);
            }
        }
        return offset;
    }

    protected int handleCommandRecordAsRtf(int byte0, int byte1, PrintWriter printWriter, int offset) {
        if (this.inHeaderOrFooter) {
            printWriter.print("}\\f0 ");
            this.inHeaderOrFooter = false;
        }
        int twipDistance = byte0 * 1440 / 10;
        switch (byte1) {
            case 237: {
                printWriter.print("{\\header ");
                this.inHeaderOrFooter = true;
                break;
            }
            case 236: {
                printWriter.print("{\\footer ");
                this.inHeaderOrFooter = true;
                break;
            }
            case 213: 
            case 214: {
                printWriter.print("}");
                break;
            }
            case 215: {
                printWriter.println("\\pard\\qr ");
                break;
            }
            case 224: {
                printWriter.println("\\pard ");
                break;
            }
            case 225: {
                printWriter.println("\\pard\\qc ");
                break;
            }
            case 223: {
                printWriter.print("\\qj ");
                break;
            }
            case 233: 
            case 244: 
            case 245: {
                printWriter.print("\\page ");
                break;
            }
            case 216: {
                printWriter.print("\\paperw");
                printWriter.print(twipDistance);
                printWriter.print(" ");
                break;
            }
            case 226: {
                printWriter.print("\\paperl");
                printWriter.print(twipDistance);
                printWriter.print(" ");
                break;
            }
            case 217: {
                printWriter.print("\\margl");
                printWriter.print(twipDistance);
                printWriter.print(" ");
                break;
            }
            case 218: {
                printWriter.print("\\margr");
                printWriter.print(twipDistance);
                printWriter.print(" ");
                break;
            }
            case 227: {
                printWriter.print("\\margt");
                printWriter.print(twipDistance);
                printWriter.print(" ");
                break;
            }
            case 228: {
                printWriter.print("\\margb");
                printWriter.print(twipDistance);
                printWriter.print(" ");
                break;
            }
            default: {
                offset = this.handleCommandRecordAsText(byte0, byte1, printWriter, offset);
            }
        }
        return offset;
    }

    protected int handleCommandRecordAsText(int byte0, int byte1, PrintWriter printWriter, int offset) {
        switch (byte1) {
            case 238: {
                for (int i = 0; i < byte0; ++i) {
                    this.handleReturn(printWriter);
                }
                break;
            }
        }
        return offset;
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        Object fileName = fileEntry.getFilename().trim();
        String extension = ".txt";
        if (this.isHtmlRendering()) {
            extension = ".html";
        } else if (this.isRtfRendering()) {
            extension = ".rtf";
        }
        if (!((String)fileName).toLowerCase().endsWith(extension)) {
            fileName = (String)fileName + extension;
        }
        return fileName;
    }

    protected void setRendering(int rendering) {
        this.rendering = rendering;
    }

    public boolean isTextRendering() {
        return this.rendering == 0;
    }

    public boolean isHtmlRendering() {
        return this.rendering == 1;
    }

    public boolean isRtfRendering() {
        return this.rendering == 2;
    }

    public void selectTextRendering() {
        this.rendering = 0;
    }

    public void selectHtmlRendering() {
        this.rendering = 1;
    }

    public void selectRtfRendering() {
        this.rendering = 2;
    }
}

