/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.compare;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.DiskGeometry;
import com.webcodepro.applecommander.storage.DiskUnrecognizedException;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.compare.ComparisonResult;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.Range;
import com.webcodepro.applecommander.util.filestreamer.FileStreamer;
import com.webcodepro.applecommander.util.filestreamer.FileTuple;
import com.webcodepro.applecommander.util.filestreamer.TypeOfFile;
import com.webcodepro.applecommander.util.readerwriter.FileEntryReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class DiskDiff {
    private Disk diskA;
    private Disk diskB;
    private ComparisonResult results = new ComparisonResult();
    private BiConsumer<FormattedDisk, FormattedDisk> diskComparisonStrategy = this::compareByNativeGeometry;

    public static ComparisonResult compare(Disk diskA, Disk diskB) {
        return new DiskDiff(diskA, diskB).compare();
    }

    public static Builder create(Disk diskA, Disk diskB) {
        return new Builder(diskA, diskB);
    }

    private DiskDiff(Disk diskA, Disk diskB) {
        Objects.requireNonNull(diskA);
        Objects.requireNonNull(diskB);
        this.diskA = diskA;
        this.diskB = diskB;
    }

    public ComparisonResult compare() {
        FormattedDisk[] formattedDisksA = null;
        try {
            formattedDisksA = this.diskA.getFormattedDisks();
        }
        catch (DiskUnrecognizedException e) {
            this.results.addError(e);
        }
        FormattedDisk[] formattedDisksB = null;
        try {
            formattedDisksB = this.diskB.getFormattedDisks();
        }
        catch (DiskUnrecognizedException e) {
            this.results.addError(e);
        }
        if (!this.results.hasErrors()) {
            this.compareAll(formattedDisksA, formattedDisksB);
        }
        return this.results;
    }

    public void compareAll(FormattedDisk[] formattedDisksA, FormattedDisk[] formattedDisksB) {
        Objects.requireNonNull(formattedDisksA);
        Objects.requireNonNull(formattedDisksB);
        if (formattedDisksA.length != formattedDisksB.length) {
            this.results.addWarning("Cannot compare all disks; %s has %d while %s has %d.", this.diskA.getFilename(), formattedDisksA.length, this.diskB.getFilename(), formattedDisksB.length);
        }
        int min = Math.min(formattedDisksA.length, formattedDisksB.length);
        for (int i = 0; i < min; ++i) {
            this.diskComparisonStrategy.accept(formattedDisksA[i], formattedDisksB[i]);
        }
    }

    public void compareByNativeGeometry(FormattedDisk formattedDiskA, FormattedDisk formattedDiskB) {
        DiskGeometry geometryB;
        DiskGeometry geometryA = formattedDiskA.getDiskGeometry();
        if (geometryA != (geometryB = formattedDiskB.getDiskGeometry())) {
            this.results.addError("Disks are different geometry (block versus track/sector)", new Object[0]);
            return;
        }
        switch (geometryA) {
            case BLOCK: {
                this.compareByBlockGeometry(formattedDiskA, formattedDiskB);
                break;
            }
            case TRACK_SECTOR: {
                this.compareByTrackSectorGeometry(formattedDiskA, formattedDiskB);
                break;
            }
            default: {
                this.results.addError("Unknown geometry: %s", new Object[]{geometryA});
            }
        }
    }

    public void compareByBlockGeometry(FormattedDisk formattedDiskA, FormattedDisk formattedDiskB) {
        ImageOrder orderA = formattedDiskA.getImageOrder();
        ImageOrder orderB = formattedDiskB.getImageOrder();
        if (orderA.getBlocksOnDevice() != orderB.getBlocksOnDevice()) {
            this.results.addError("Different sized disks do not equal. (Blocks: %d <> %d)", orderA.getBlocksOnDevice(), orderB.getBlocksOnDevice());
            return;
        }
        ArrayList<Integer> unequalBlocks = new ArrayList<Integer>();
        for (int block = 0; block < orderA.getBlocksOnDevice(); ++block) {
            byte[] blockB;
            byte[] blockA = orderA.readBlock(block);
            if (Arrays.equals(blockA, blockB = orderB.readBlock(block))) continue;
            unequalBlocks.add(block);
        }
        for (Range r : Range.from(unequalBlocks)) {
            if (r.size() == 1) {
                this.results.addError("Block #%s does not match.", r);
                continue;
            }
            this.results.addError("Blocks #%s do not match.", r);
        }
    }

    public void compareByTrackSectorGeometry(FormattedDisk formattedDiskA, FormattedDisk formattedDiskB) {
        ImageOrder orderA = formattedDiskA.getImageOrder();
        ImageOrder orderB = formattedDiskB.getImageOrder();
        if (orderA.getSectorsPerDisk() != orderB.getSectorsPerDisk()) {
            this.results.addError("Different sized disks do not equal. (Sectors: %d <> %d)", orderA.getSectorsPerDisk(), orderB.getSectorsPerDisk());
            return;
        }
        for (int track = 0; track < orderA.getTracksPerDisk(); ++track) {
            ArrayList<Integer> unequalSectors = new ArrayList<Integer>();
            for (int sector = 0; sector < orderA.getSectorsPerTrack(); ++sector) {
                byte[] sectorB;
                byte[] sectorA = orderA.readSector(track, sector);
                if (Arrays.equals(sectorA, sectorB = orderB.readSector(track, sector))) continue;
                unequalSectors.add(sector);
            }
            if (unequalSectors.isEmpty()) continue;
            this.results.addError("Track %d does not match on sectors %s", track, Range.from(unequalSectors).stream().map(Range::toString).collect(Collectors.joining(",")));
        }
    }

    public void compareByFileName(FormattedDisk formattedDiskA, FormattedDisk formattedDiskB) {
        try {
            Map<String, List<FileTuple>> filesA = FileStreamer.forDisk(formattedDiskA).includeTypeOfFile(TypeOfFile.FILE).recursive(true).stream().collect(Collectors.groupingBy(FileTuple::fullPath));
            Map<String, List<FileTuple>> filesB = FileStreamer.forDisk(formattedDiskB).includeTypeOfFile(TypeOfFile.FILE).recursive(true).stream().collect(Collectors.groupingBy(FileTuple::fullPath));
            HashSet<String> pathsOnlyA = new HashSet<String>(filesA.keySet());
            pathsOnlyA.removeAll(filesB.keySet());
            if (!pathsOnlyA.isEmpty()) {
                this.results.addError("Files only in %s: %s", formattedDiskA.getFilename(), String.join((CharSequence)", ", pathsOnlyA));
            }
            HashSet<String> pathsOnlyB = new HashSet<String>(filesB.keySet());
            pathsOnlyB.removeAll(filesA.keySet());
            if (!pathsOnlyB.isEmpty()) {
                this.results.addError("Files only in %s: %s", formattedDiskB.getFilename(), String.join((CharSequence)", ", pathsOnlyB));
            }
            HashSet<String> pathsInAB = new HashSet<String>(filesA.keySet());
            pathsInAB.retainAll(filesB.keySet());
            for (String path : pathsInAB) {
                FileEntryReader readerB;
                FileEntryReader readerA;
                List<String> differences;
                List<FileTuple> tuplesA = filesA.get(path);
                List<FileTuple> tuplesB = filesB.get(path);
                FileTuple tupleA = tuplesA.get(0);
                if (tuplesA.size() > 1) {
                    this.results.addWarning("Path %s on disk %s has %d entries.", path, formattedDiskA.getFilename(), tuplesA.size());
                }
                FileTuple tupleB = tuplesB.get(0);
                if (tuplesB.size() > 1) {
                    this.results.addWarning("Path %s on disk %s has %d entries.", path, formattedDiskB.getFilename(), tuplesB.size());
                }
                if ((differences = this.compare(readerA = FileEntryReader.get(tupleA.fileEntry), readerB = FileEntryReader.get(tupleB.fileEntry))).isEmpty()) continue;
                this.results.addWarning("Path %s differ: %s", path, String.join((CharSequence)", ", differences));
            }
        }
        catch (DiskException ex) {
            this.results.addError(ex);
        }
    }

    public void compareByFileContent(FormattedDisk formattedDiskA, FormattedDisk formattedDiskB) {
        try {
            Map<String, List<FileTuple>> contentA = FileStreamer.forDisk(formattedDiskA).includeTypeOfFile(TypeOfFile.FILE).recursive(true).stream().collect(Collectors.groupingBy(this::contentHash));
            Map<String, List<FileTuple>> contentB = FileStreamer.forDisk(formattedDiskB).includeTypeOfFile(TypeOfFile.FILE).recursive(true).stream().collect(Collectors.groupingBy(this::contentHash));
            HashSet<String> contentOnlyA = new HashSet<String>(contentA.keySet());
            contentOnlyA.removeAll(contentB.keySet());
            if (!contentOnlyA.isEmpty()) {
                Set pathNamesA = contentOnlyA.stream().map(contentA::get).flatMap(Collection::stream).map(FileTuple::fullPath).collect(Collectors.toSet());
                this.results.addError("Content that only exists in %s: %s", formattedDiskA.getFilename(), String.join((CharSequence)", ", pathNamesA));
            }
            HashSet<String> contentOnlyB = new HashSet<String>(contentB.keySet());
            contentOnlyB.removeAll(contentA.keySet());
            if (!contentOnlyB.isEmpty()) {
                Set pathNamesB = contentOnlyB.stream().map(contentB::get).flatMap(Collection::stream).map(FileTuple::fullPath).collect(Collectors.toSet());
                this.results.addError("Content that only exists in %s: %s", formattedDiskB.getFilename(), String.join((CharSequence)", ", pathNamesB));
            }
            HashSet<String> contentInAB = new HashSet<String>(contentA.keySet());
            contentInAB.retainAll(contentB.keySet());
            for (String content : contentInAB) {
                FileEntryReader readerB;
                FileEntryReader readerA;
                List<String> differences;
                List<FileTuple> tuplesA = contentA.get(content);
                List<FileTuple> tuplesB = contentB.get(content);
                FileTuple tupleA = tuplesA.get(0);
                if (tuplesA.size() > 1) {
                    this.results.addWarning("Hash %s on disk %s has %d entries.", content, formattedDiskA.getFilename(), tuplesA.size());
                }
                FileTuple tupleB = tuplesB.get(0);
                if (tuplesB.size() > 1) {
                    this.results.addWarning("Hash %s on disk %s has %d entries.", content, formattedDiskB.getFilename(), tuplesB.size());
                }
                if ((differences = this.compare(readerA = FileEntryReader.get(tupleA.fileEntry), readerB = FileEntryReader.get(tupleB.fileEntry))).isEmpty()) continue;
                this.results.addWarning("Files %s and %s share same content but file attributes differ: %s", tupleA.fullPath(), tupleB.fullPath(), String.join((CharSequence)", ", differences));
            }
        }
        catch (DiskException ex) {
            this.results.addError(ex);
        }
    }

    private String contentHash(FileTuple tuple) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] digest = messageDigest.digest(tuple.fileEntry.getFileData());
            return String.format("%032X", new BigInteger(1, digest));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private List<String> compare(FileEntryReader readerA, FileEntryReader readerB) {
        ArrayList<String> differences = new ArrayList<String>();
        if (!readerA.getFilename().equals(readerB.getFilename())) {
            differences.add("filename");
        }
        if (!readerA.getProdosFiletype().equals(readerB.getProdosFiletype())) {
            differences.add("filetype");
        }
        if (!readerA.isLocked().equals(readerB.isLocked())) {
            differences.add("locked");
        }
        if (!Arrays.equals(readerA.getFileData().orElse(null), readerB.getFileData().orElse(null))) {
            differences.add("file data");
        }
        if (!Arrays.equals(readerA.getResourceData().orElse(null), readerB.getResourceData().orElse(null))) {
            differences.add("resource fork");
        }
        if (!readerA.getBinaryAddress().equals(readerB.getBinaryAddress())) {
            differences.add("address");
        }
        if (!readerA.getBinaryLength().equals(readerB.getBinaryLength())) {
            differences.add("length");
        }
        if (!readerA.getAuxiliaryType().equals(readerB.getAuxiliaryType())) {
            differences.add("aux. type");
        }
        if (!readerA.getCreationDate().equals(readerB.getCreationDate())) {
            differences.add("create date");
        }
        if (!readerA.getLastModificationDate().equals(readerB.getLastModificationDate())) {
            differences.add("mod. date");
        }
        return differences;
    }

    public static class Builder {
        private DiskDiff diff;

        public Builder(Disk diskA, Disk diskB) {
            this.diff = new DiskDiff(diskA, diskB);
        }

        public Builder selectCompareByNativeGeometry() {
            this.diff.diskComparisonStrategy = this.diff::compareByNativeGeometry;
            return this;
        }

        public Builder selectCompareByTrackSectorGeometry() {
            this.diff.diskComparisonStrategy = this.diff::compareByTrackSectorGeometry;
            return this;
        }

        public Builder selectCompareByBlockGeometry() {
            this.diff.diskComparisonStrategy = this.diff::compareByBlockGeometry;
            return this;
        }

        public Builder selectCompareByFileName() {
            this.diff.diskComparisonStrategy = this.diff::compareByFileName;
            return this;
        }

        public Builder selectCompareByFileContent() {
            this.diff.diskComparisonStrategy = this.diff::compareByFileContent;
            return this;
        }

        public ComparisonResult compare() {
            return this.diff.compare();
        }
    }
}

