/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.compare;

import java.util.ArrayList;
import java.util.List;

public class ComparisonResult {
    private List<String> errors = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public int getDifferenceCount() {
        return this.errors.size() + this.warnings.size();
    }

    public List<String> getAllMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        messages.addAll(this.errors);
        messages.addAll(this.warnings);
        return messages;
    }

    public List<String> getLimitedMessages(int limit) {
        List<String> messages = this.getAllMessages();
        return messages.subList(0, Math.min(messages.size(), limit));
    }

    public void addError(Exception ex) {
        this.errors.add(ex.getMessage());
    }

    public void addError(String fmt, Object ... args) {
        this.errors.add(String.format(fmt, args));
    }

    public void addWarning(String fmt, Object ... args) {
        this.warnings.add(String.format(fmt, args));
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }
}

