/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage;

import com.webcodepro.applecommander.storage.DiskUnrecognizedException;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.cpm.CpmFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.OzDosFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.UniDosFormatDisk;
import com.webcodepro.applecommander.storage.os.gutenberg.GutenbergFormatDisk;
import com.webcodepro.applecommander.storage.os.nakedos.NakedosFormatDisk;
import com.webcodepro.applecommander.storage.os.pascal.PascalFormatDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.os.rdos.RdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.storage.physical.NibbleOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.storage.physical.UniversalDiskImageLayout;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.ShrinkItUtilities;
import com.webcodepro.applecommander.util.StreamUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Disk {
    public static final int BLOCK_SIZE = 512;
    public static final int SECTOR_SIZE = 256;
    public static final int PRODOS_BLOCKS_ON_140KB_DISK = 280;
    public static final int DOS33_SECTORS_ON_140KB_DISK = 560;
    public static final int APPLE_140KB_DISK = 143360;
    public static final int APPLE_140KB_NIBBLE_DISK = 232960;
    public static final int APPLE_800KB_DISK = 819200;
    public static final int APPLE_800KB_2IMG_DISK = 819264;
    public static final int APPLE_5MB_HARDDISK = 0x500000;
    public static final int APPLE_10MB_HARDDISK = 0xA00000;
    public static final int APPLE_20MB_HARDDISK = 0x1400000;
    public static final int APPLE_32MB_HARDDISK = 33553920;
    private static FilenameFilter[] filenameFilters;
    private static String[] allFileExtensions;
    private TextBundle textBundle = StorageBundle.getInstance();
    private String filename;
    private boolean newImage = false;
    private boolean isDC42 = false;
    private ByteArrayImageLayout diskImageManager;
    private ImageOrder imageOrder = null;

    public static FilenameFilter[] getFilenameFilters() {
        if (filenameFilters == null) {
            new Disk();
        }
        return filenameFilters;
    }

    public static String[] getAllExtensions() {
        if (allFileExtensions == null) {
            new Disk();
        }
        return allFileExtensions;
    }

    private Disk() {
        filenameFilters = new FilenameFilter[]{new FilenameFilter(this.textBundle.get("Disk.AllImages"), "*.do", "*.dsk", "*.po", "*.nib", "*.2mg", "*.2img", "*.hdv", "*.do.gz", "*.dsk.gz", "*.po.gz", "*.nib.gz", "*.2mg.gz", "*.2img.gz"), new FilenameFilter(this.textBundle.get("Disk.140kDosImages"), "*.do", "*.dsk", "*.do.gz", "*.dsk.gz"), new FilenameFilter(this.textBundle.get("Disk.140kNibbleImages"), "*.nib", "*.nib.gz"), new FilenameFilter(this.textBundle.get("Disk.140kProdosImages"), "*.po", "*.po.gz"), new FilenameFilter(this.textBundle.get("Disk.800kProdosImages"), "*.2mg", "*.2img", "*.2mg.gz", "*.2img.gz"), new FilenameFilter(this.textBundle.get("Disk.ApplePcImages"), "*.hdv"), new FilenameFilter(this.textBundle.get("Disk.CompressedImages"), "*.sdk", "*.shk", "*.do.gz", "*.dsk.gz", "*.po.gz", "*.2mg.gz", "*.2img.gz"), new FilenameFilter(this.textBundle.get("Disk.AllFiles"), "*.*")};
        allFileExtensions = new String[]{".do", ".dsk", ".po", ".nib", ".sdk", ".shk", ".2mg", ".2img", ".hdv", ".do.gz", ".dsk.gz", ".po.gz", ".nib.gz", ".2mg.gz", ".2img.gz"};
    }

    protected Disk(String filename, ImageOrder imageOrder) {
        this.imageOrder = imageOrder;
        this.filename = filename;
        this.newImage = true;
    }

    public Disk(String filename) throws IOException {
        this(filename, 0, false);
    }

    public Disk(String filename, boolean knownProDOSOrder) throws IOException {
        this(filename, 0, knownProDOSOrder);
    }

    public Disk(String filename, int startBlocks) throws IOException {
        this(filename, startBlocks, false);
    }

    public Disk(String filename, int startBlocks, boolean knownProDOSOrder) throws IOException {
        this.filename = filename;
        int diskSize = 0;
        byte[] diskImage = null;
        byte[] diskImageDC42 = null;
        if (this.isSDK() || this.isSHK() || this.isBXY()) {
            diskImage = ShrinkItUtilities.unpackSHKFile(filename, startBlocks);
            diskSize = diskImage.length;
            this.filename = this.filename + ".po";
        } else {
            File file = new File(filename);
            diskSize = (int)file.length();
            InputStream input = new FileInputStream(file);
            if (this.isCompressed()) {
                input = new GZIPInputStream(input);
            }
            ByteArrayOutputStream diskImageByteArray = new ByteArrayOutputStream(diskSize);
            StreamUtil.copy(input, diskImageByteArray);
            diskImage = diskImageByteArray.toByteArray();
        }
        boolean is2img = false;
        if (diskImage[0] == 50 && diskImage[1] == 73 && diskImage[2] == 77 && diskImage[3] == 71) {
            is2img = true;
        } else if (Disk.isDC42(diskImage)) {
            this.isDC42 = true;
            long end = AppleUtil.getLongValue(diskImage, 64);
            if (end < (long)(diskImage.length - 83)) {
                diskImageDC42 = new byte[(int)end];
                System.arraycopy(diskImage, 84, diskImageDC42, 0, (int)end);
                this.diskImageManager = new ByteArrayImageLayout(diskImageDC42);
                this.filename = this.filename + ".po";
            } else {
                throw new IllegalArgumentException(this.textBundle.get("CommandLineDC42Bad"));
            }
        }
        this.diskImageManager = is2img || diskImage.length == 819264 || diskImage.length == 0x500040 || diskImage.length == 0xA00040 || diskImage.length == 0x1400040 || diskImage.length == 33553984 ? new UniversalDiskImageLayout(diskImage) : (this.isDC42 ? new ByteArrayImageLayout(diskImageDC42) : new ByteArrayImageLayout(diskImage));
        DosOrder dosOrder = new DosOrder(this.diskImageManager);
        ProdosOrder proDosOrder = new ProdosOrder(this.diskImageManager);
        if (this.isSDK()) {
            this.imageOrder = proDosOrder;
        } else {
            int rc = -1;
            if (diskSize == 143360) {
                this.imageOrder = dosOrder;
                if ((this.isProdosFormat() || this.isDosFormat()) && !knownProDOSOrder) {
                    rc = 0;
                } else {
                    this.imageOrder = proDosOrder;
                    if (knownProDOSOrder || this.isProdosFormat() || this.isDosFormat()) {
                        rc = 0;
                    }
                }
                if (rc == -1) {
                    if (this.isProdosOrder() || this.is2ImgOrder()) {
                        this.imageOrder = proDosOrder;
                        rc = 0;
                    } else if (this.isDosOrder()) {
                        this.imageOrder = dosOrder;
                        rc = 0;
                    } else if (this.isNibbleOrder()) {
                        this.imageOrder = new NibbleOrder(this.diskImageManager);
                        rc = 0;
                    }
                }
                if (rc == -1) {
                    this.imageOrder = dosOrder;
                    rc = this.testImageOrder();
                }
            }
            if (rc == -1) {
                this.imageOrder = proDosOrder;
                rc = this.testImageOrder();
                if (rc == -1) {
                    this.imageOrder = this.isProdosOrder() || this.is2ImgOrder() ? proDosOrder : (this.isDosOrder() ? dosOrder : (this.isNibbleOrder() ? new NibbleOrder(this.diskImageManager) : proDosOrder));
                }
            }
        }
    }

    public int testImageOrder() {
        int rc = (true == this.isProdosFormat() ? 1 : 0) + (true == this.isDosFormat() ? 2 : 0) + (true == this.isCpmFormat() ? 4 : 0) + (true == this.isUniDosFormat() ? 8 : 0) + (true == this.isPascalFormat() ? 16 : 0) + (true == this.isOzDosFormat() ? 32 : 0);
        if (rc == 0) {
            rc = -1;
        }
        return rc;
    }

    public void save() throws IOException {
        File file = new File(this.getFilename());
        if (!file.exists()) {
            file.createNewFile();
        }
        OutputStream output = new FileOutputStream(file);
        if (this.isCompressed()) {
            output = new GZIPOutputStream(output);
        }
        output.write(this.getDiskImageManager().getDiskImage());
        output.close();
        this.getDiskImageManager().setChanged(false);
        this.newImage = false;
    }

    public void saveAs(String filename) throws IOException {
        this.filename = filename;
        this.save();
    }

    public FormattedDisk[] getFormattedDisks() throws DiskUnrecognizedException {
        if (this.isProdosFormat()) {
            return new FormattedDisk[]{new ProdosFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isUniDosFormat()) {
            return new FormattedDisk[]{new UniDosFormatDisk(this.filename, this.imageOrder, 0), new UniDosFormatDisk(this.filename, this.imageOrder, 50)};
        }
        if (this.isOzDosFormat()) {
            return new FormattedDisk[]{new OzDosFormatDisk(this.filename, this.imageOrder, 0), new OzDosFormatDisk(this.filename, this.imageOrder, 256)};
        }
        if (this.isDosFormat()) {
            return new FormattedDisk[]{new DosFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isNakedosFormat()) {
            return new FormattedDisk[]{new NakedosFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isPascalFormat()) {
            return new FormattedDisk[]{new PascalFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isRdosFormat()) {
            return new FormattedDisk[]{new RdosFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isCpmFormat()) {
            return new FormattedDisk[]{new CpmFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isWPFormat()) {
            return new FormattedDisk[]{new GutenbergFormatDisk(this.filename, this.imageOrder)};
        }
        throw new DiskUnrecognizedException(this.filename);
    }

    public ByteArrayImageLayout getDiskImageManager() {
        if (this.imageOrder != null) {
            return this.imageOrder.getDiskImageManager();
        }
        return this.diskImageManager;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getOrderName() {
        return this.imageOrder == null ? this.textBundle.get("FormattedDisk.Unknown") : this.imageOrder.getName();
    }

    public boolean isCompressed() {
        return this.filename.toLowerCase().endsWith(".gz");
    }

    public boolean isSDK() {
        return this.filename.toLowerCase().endsWith(".sdk");
    }

    public boolean isSHK() {
        return this.filename.toLowerCase().endsWith(".shk");
    }

    public boolean isBXY() {
        return this.filename.toLowerCase().endsWith(".bxy");
    }

    public boolean isProdosOrder() {
        return this.filename.toLowerCase().endsWith(".po") || this.filename.toLowerCase().endsWith(".po.gz") || this.is2ImgOrder() || this.filename.toLowerCase().endsWith(".hdv") || this.getPhysicalSize() >= 819264;
    }

    public boolean isDosOrder() {
        return this.filename.toLowerCase().endsWith(".do") || this.filename.toLowerCase().endsWith(".do.gz") || this.filename.toLowerCase().endsWith(".dsk") || this.filename.toLowerCase().endsWith(".dsk.gz");
    }

    public boolean is2ImgOrder() {
        return this.filename.toLowerCase().endsWith(".2img") || this.filename.toLowerCase().endsWith(".2img.gz") || this.filename.toLowerCase().endsWith(".2mg") || this.filename.toLowerCase().endsWith(".2mg.gz");
    }

    public boolean isNibbleOrder() {
        return this.filename.toLowerCase().endsWith(".nib") || this.filename.toLowerCase().endsWith(".nib.gz");
    }

    public int getPhysicalSize() {
        if (this.getDiskImageManager() != null) {
            return this.getDiskImageManager().getPhysicalSize();
        }
        return this.getImageOrder().getPhysicalSize();
    }

    protected void resizeDiskImage(int newSize) {
        if (newSize < this.getPhysicalSize()) {
            throw new IllegalArgumentException(this.textBundle.get("Disk.ResizeDiskError"));
        }
        byte[] newDiskImage = new byte[newSize];
        byte[] oldDiskImage = this.imageOrder.getDiskImageManager().getDiskImage();
        System.arraycopy(oldDiskImage, 0, newDiskImage, 0, oldDiskImage.length);
        this.imageOrder.getDiskImageManager().setDiskImage(newDiskImage);
    }

    public byte[] readBlock(int block) {
        return this.imageOrder.readBlock(block);
    }

    public void writeBlock(int block, byte[] data) {
        this.imageOrder.writeBlock(block, data);
    }

    public byte[] readSector(int track, int sector) throws IllegalArgumentException {
        return this.imageOrder.readSector(track, sector);
    }

    public void writeSector(int track, int sector, byte[] bytes) throws IllegalArgumentException {
        this.imageOrder.writeSector(track, sector, bytes);
    }

    public boolean isProdosFormat() {
        byte[] prodosVolumeDirectory = this.readBlock(2);
        byte volDirEntryLength = prodosVolumeDirectory[35];
        byte volDirEntriesPerBlock = prodosVolumeDirectory[36];
        return prodosVolumeDirectory[0] == 0 && prodosVolumeDirectory[1] == 0 && (prodosVolumeDirectory[4] & 0xF0) == 240 && volDirEntryLength * volDirEntriesPerBlock <= 512;
    }

    public boolean isDosFormat() {
        boolean good = false;
        if (!this.is140KbDisk()) {
            return false;
        }
        try {
            byte catSect;
            byte[] cat;
            byte catTrack;
            byte[] vtoc = this.readSector(17, 0);
            boolean bl = good = !(!this.imageOrder.isSizeApprox(143360) && !this.imageOrder.isSizeApprox(232960) || vtoc[1] != 17 || vtoc[39] != 122 || vtoc[52] != 35 && vtoc[52] != 40 || vtoc[53] != 16);
            if (good && (catTrack = vtoc[1]) == (cat = this.readSector(catTrack, catSect = vtoc[2]))[1] && catSect == cat[2] + 1) {
                catTrack = cat[1];
                catSect = cat[2];
                good = catTrack == (cat = this.readSector(catTrack, catSect))[1] && catSect == cat[2] + 1;
            }
        }
        catch (Exception ex) {
            good = false;
        }
        return good;
    }

    public boolean isUniDosFormat() {
        if (!this.is800KbDisk()) {
            return false;
        }
        byte[] vtoc1 = this.readSector(17, 0);
        byte[] vtoc2 = this.readSector(67, 0);
        return vtoc1[1] == 17 && vtoc1[2] == 31 && vtoc1[39] == 122 && vtoc1[52] == 50 && vtoc1[53] == 32 && vtoc1[54] == 0 && vtoc1[55] == 1 && vtoc2[1] == 17 && vtoc2[2] == 31 && vtoc2[39] == 122 && vtoc2[52] == 50 && vtoc2[53] == 32 && vtoc2[54] == 0 && vtoc2[55] == 1;
    }

    public boolean isOzDosFormat() {
        if (!this.is800KbDisk()) {
            return false;
        }
        byte[] vtoc = this.readBlock(544);
        return vtoc[1] == 17 && vtoc[2] == 31 && vtoc[39] == 122 && vtoc[52] == 50 && vtoc[53] == 32 && vtoc[54] == 0 && vtoc[55] == 1 && vtoc[311] == 1 && vtoc[257] == 17 && vtoc[258] == 31 && vtoc[295] == 122 && vtoc[308] == 50 && vtoc[309] == 32 && vtoc[310] == 0 && vtoc[311] == 1;
    }

    public boolean isNakedosFormat() {
        if (!this.is140KbDisk()) {
            return false;
        }
        byte[] vtoc = this.readSector(0, 3);
        return (this.imageOrder.isSizeApprox(143360) || this.imageOrder.isSizeApprox(232960)) && vtoc[208] == -2 && vtoc[209] == -2 && vtoc[210] == -2 && vtoc[211] == -2 && vtoc[212] == -2 && vtoc[213] == -2 && vtoc[214] == -2 && vtoc[215] == -2 && vtoc[216] == -2 && vtoc[217] == -2 && vtoc[218] == -2 && vtoc[219] == -2 && vtoc[220] != -2;
    }

    public boolean isPascalFormat() {
        if (!this.is140KbDisk() && !this.is800KbDisk()) {
            return false;
        }
        byte[] directory = this.readBlock(2);
        return directory[0] == 0 && directory[1] == 0 && directory[2] == 6 && directory[3] == 0 && directory[4] == 0 && directory[5] == 0;
    }

    public boolean isCpmFormat() {
        if (!this.is140KbDisk()) {
            return false;
        }
        byte[] directory = this.readSector(3, 0);
        int[] bytes = new int[256];
        for (int i = 0; i < directory.length; ++i) {
            bytes[i] = AppleUtil.getUnsignedByte(directory[i]);
        }
        for (int offset = 0; offset < directory.length; offset += 32) {
            int i;
            int e5count = 0;
            for (i = 0; i < 32; ++i) {
                e5count += bytes[offset + i] == 229 ? 1 : 0;
            }
            if (e5count == 32) continue;
            if (bytes[offset] > 15 && bytes[offset] != 229) {
                return false;
            }
            for (i = 0; i < 8; ++i) {
                if (bytes[offset + 1 + i] <= 127) continue;
                return false;
            }
            if (bytes[offset + 12] > 31 || bytes[offset + 14] > 0) {
                return false;
            }
            if (bytes[offset + 15] <= 128) continue;
            return false;
        }
        return true;
    }

    protected boolean is140KbDisk() {
        return this.getPhysicalSize() >= 143360 && this.getPhysicalSize() <= 232960;
    }

    protected boolean is800KbDisk() {
        return this.getPhysicalSize() >= 819200 && this.getPhysicalSize() <= 819264;
    }

    public boolean isRdosFormat() {
        if (!this.is140KbDisk()) {
            return false;
        }
        byte[] block = this.readSector(0, 13);
        String id = AppleUtil.getString(block, 224, 4);
        return "RDOS".equals(id);
    }

    public boolean isWPFormat() {
        if (!this.is140KbDisk()) {
            return false;
        }
        byte[] vtoc = this.readSector(17, 7);
        return (this.imageOrder.isSizeApprox(143360) || this.imageOrder.isSizeApprox(232960)) && vtoc[0] == 17 && vtoc[1] == 7 && vtoc[15] == -115;
    }

    private static boolean isDC42(byte[] buffer) {
        return buffer[82] == 1 && buffer[83] == 0 && (buffer[81] == 2 || buffer[81] == 34 || buffer[81] == 36);
    }

    public boolean isDC42() {
        return this.isDC42;
    }

    public boolean hasChanged() {
        return this.getDiskImageManager().hasChanged();
    }

    public boolean isNewImage() {
        return this.newImage;
    }

    public ImageOrder getImageOrder() {
        return this.imageOrder;
    }

    protected void setImageOrder(ImageOrder imageOrder) {
        this.imageOrder = imageOrder;
    }

    public void makeDosOrder() {
        DosOrder doso = new DosOrder(new ByteArrayImageLayout(143360));
        this.changeImageOrderByTrackAndSector(this.getImageOrder(), doso);
        this.setImageOrder(doso);
    }

    public void makeProdosOrder() {
        ProdosOrder pdo = new ProdosOrder(new ByteArrayImageLayout(143360));
        this.changeImageOrderByBlock(this.getImageOrder(), pdo);
        this.setImageOrder(pdo);
    }

    public static int sizeToFit(long bytes) {
        if (bytes < 143360L) {
            return 143360;
        }
        if (bytes < 819200L) {
            return 819200;
        }
        if (bytes < 0x500000L) {
            return 0x500000;
        }
        if (bytes < 0xA00000L) {
            return 0xA00000;
        }
        if (bytes < 0x1400000L) {
            return 0x1400000;
        }
        if (bytes < 33553920L) {
            return 0x1400000;
        }
        if (bytes < 33553920L) {
            return 33553920;
        }
        return -1;
    }

    private void changeImageOrderByTrackAndSector(ImageOrder sourceOrder, ImageOrder targetOrder) {
        if (!Disk.sameSectorsPerDisk(sourceOrder, targetOrder)) {
            throw new IllegalArgumentException(this.textBundle.get("Disk.ResizeDiskError"));
        }
        for (int track = 0; track < sourceOrder.getTracksPerDisk(); ++track) {
            for (int sector = 0; sector < sourceOrder.getSectorsPerTrack(); ++sector) {
                byte[] data = sourceOrder.readSector(track, sector);
                targetOrder.writeSector(track, sector, data);
            }
        }
    }

    private void changeImageOrderByBlock(ImageOrder sourceOrder, ImageOrder targetOrder) {
        if (!Disk.sameBlocksPerDisk(sourceOrder, targetOrder)) {
            throw new IllegalArgumentException(this.textBundle.get("Disk.ResizeDiskError"));
        }
        for (int block = 0; block < sourceOrder.getBlocksOnDevice(); ++block) {
            byte[] blockData = sourceOrder.readBlock(block);
            targetOrder.writeBlock(block, blockData);
        }
    }

    private static boolean sameBlocksPerDisk(ImageOrder sourceOrder, ImageOrder targetOrder) {
        return sourceOrder.getBlocksOnDevice() == targetOrder.getBlocksOnDevice();
    }

    private static boolean sameSectorsPerDisk(ImageOrder sourceOrder, ImageOrder targetOrder) {
        return sourceOrder.getSectorsPerDisk() == targetOrder.getSectorsPerDisk();
    }

    static {
        allFileExtensions = null;
    }

    public class FilenameFilter {
        private String names;
        private String[] extensions;

        public FilenameFilter(String names, String ... extensions) {
            this.names = names;
            this.extensions = extensions;
        }

        public String getExtensions() {
            return String.join((CharSequence)";", this.extensions);
        }

        public String[] getExtensionList() {
            return this.extensions;
        }

        public String getNames() {
            return this.names;
        }
    }
}

