/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.compiler;

import com.webcodepro.applecommander.compiler.CompileException;
import com.webcodepro.applecommander.compiler.CompilerBundle;
import com.webcodepro.applecommander.compiler.Variable;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.util.ApplesoftToken;
import com.webcodepro.applecommander.util.ApplesoftTokenizer;
import com.webcodepro.applecommander.util.ApplesoftTokens;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class ApplesoftCompiler
implements ApplesoftTokens {
    private TextBundle textBundle = CompilerBundle.getInstance();
    private ApplesoftTokenizer tokenizer;
    private ApplesoftToken tokenAlreadySeen;
    private StringBuffer sourceAssembly = new StringBuffer();
    private StringBuffer sourceLine = new StringBuffer();
    private Map<String, String> knownAddresses = new HashMap<String, String>();
    private List<String> usedAddresses = new ArrayList<String>();
    private List<Variable> variables = new ArrayList<Variable>();
    private Map<String, Method> commandMethods = new HashMap<String, Method>();
    private Stack<String> loopVariables = new Stack();
    private boolean integerOnlyMath;

    public ApplesoftCompiler(FileEntry fileEntry) {
        this.tokenizer = new ApplesoftTokenizer(fileEntry);
        this.initializeKnownAddresses();
    }

    protected void initializeKnownAddresses() {
        InputStream inputStream = this.getClass().getResourceAsStream("AppleMemoryAddresses.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            for (String key : properties.stringPropertyNames()) {
                this.knownAddresses.put(key, properties.getProperty(key));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected boolean hasMoreTokens() {
        return this.peekToken() != null;
    }

    protected ApplesoftToken nextToken() {
        ApplesoftToken token = this.tokenAlreadySeen;
        if (this.tokenAlreadySeen != null) {
            this.tokenAlreadySeen = null;
        } else {
            token = this.tokenizer.getNextToken();
        }
        if (token != null) {
            if (token.isLineNumber()) {
                this.sourceLine.append("* ");
                this.sourceLine.append(token.getLineNumber());
                this.sourceLine.append(" ");
            } else if (token.isToken()) {
                this.sourceLine.append(token.getTokenString());
            } else if (token.isString()) {
                this.sourceLine.append(token.getStringValue());
            }
        }
        return token;
    }

    protected ApplesoftToken peekToken() {
        if (this.tokenAlreadySeen == null) {
            this.tokenAlreadySeen = this.tokenizer.getNextToken();
        }
        return this.tokenAlreadySeen;
    }

    public byte[] compile() throws CompileException {
        StringBuffer programCode = new StringBuffer();
        while (this.hasMoreTokens()) {
            ApplesoftToken token = this.nextToken();
            if (!token.isLineNumber()) {
                throw new CompileException(this.textBundle.get("ApplesoftCompiler.ExpectLineNumberError"));
            }
            this.sourceAssembly.append("LINE");
            this.sourceAssembly.append(token.getLineNumber());
            this.sourceAssembly.append("\n");
            do {
                this.evaluateCommand();
                token = this.peekToken();
                if (token == null || !token.isCommandSeparator()) continue;
                token = this.nextToken();
            } while (token != null && token.isCommandSeparator());
            programCode.append(this.sourceLine);
            programCode.append("\n");
            programCode.append(this.sourceAssembly);
            programCode.append("\n");
            this.sourceLine.setLength(0);
            this.sourceAssembly.setLength(0);
        }
        programCode.insert(0, this.buildUsedAddresses());
        programCode.append(this.buildVariableSection());
        this.sourceLine.setLength(0);
        this.sourceAssembly.setLength(0);
        return programCode.toString().getBytes();
    }

    protected StringBuffer buildUsedAddresses() {
        StringBuffer buf = new StringBuffer();
        if (this.usedAddresses.size() > 0) {
            buf.append("* Addresses:\n");
            for (int i = 0; i < this.usedAddresses.size(); ++i) {
                String label = this.usedAddresses.get(i);
                buf.append(label);
                buf.append(" = ");
                buf.append(this.knownAddresses.get(label));
                buf.append("\n");
            }
            buf.append("\n");
        }
        return buf;
    }

    protected StringBuffer buildVariableSection() {
        this.sourceAssembly.setLength(0);
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable;
            if (i == 0) {
                this.sourceAssembly.append("\n");
                this.sourceAssembly.append("* Variables:\n");
            }
            if ((variable = this.variables.get(i)).isConstantInteger()) {
                this.addAssembly(variable.getName(), "DW", variable.getValue());
                continue;
            }
            if (variable.isConstantFloat()) continue;
            if (variable.isConstantString()) {
                this.addAssembly(variable.getName(), "ASC", variable.getValue());
                this.addAssembly(null, "HEX", "00");
                continue;
            }
            if (variable.isTypeFloat()) {
                this.addAssembly(variable.getName(), "HEX", "8400000000");
                continue;
            }
            if (variable.isTypeInteger()) {
                this.addAssembly(variable.getName(), "DS", "2");
                continue;
            }
            if (!variable.isTypeString()) continue;
        }
        return this.sourceAssembly;
    }

    protected void evaluateCommand() {
        ApplesoftToken token = this.nextToken();
        while (token != null && token.isCommandSeparator()) {
            token = this.nextToken();
        }
        if (token == null || !token.isToken()) {
            return;
        }
        Method method = this.getMethod(token);
        if (method != null) {
            try {
                method.invoke((Object)this, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                System.err.println(this.textBundle.format("ApplesoftCompiler.UnableToLocateError", method.getName()));
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                System.err.println(this.textBundle.format("ApplesoftCompiler.UnableToLocateError", method.getName()));
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                System.err.println(this.textBundle.format("ApplesoftCompiler.UnableToLocateError", method.getName()));
                e.printStackTrace();
            }
        } else {
            while (this.peekToken() != null && !this.peekToken().isCommandSeparator() && !this.peekToken().isLineNumber()) {
                this.nextToken();
            }
        }
    }

    protected Method getMethod(ApplesoftToken token) {
        StringBuffer buf = new StringBuffer();
        buf.append("evaluate");
        buf.append(token.getTokenString().trim());
        for (int i = buf.length() - 1; i >= 0; --i) {
            if (buf.charAt(i) != '=') continue;
            buf.deleteCharAt(i);
        }
        String tokenName = buf.toString();
        Method method = this.commandMethods.get(tokenName);
        if (method == null) {
            try {
                method = this.getClass().getMethod(tokenName, new Class[0]);
                this.commandMethods.put(tokenName, method);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return null;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return method;
    }

    protected void addAssembly(String label, String mnemonic, String parameter) {
        if (label != null) {
            this.sourceAssembly.append(label);
        }
        if (mnemonic != null) {
            this.sourceAssembly.append(" ");
            this.sourceAssembly.append(mnemonic);
            if (parameter != null) {
                this.sourceAssembly.append(" ");
                this.sourceAssembly.append(parameter);
                if (!this.usedAddresses.contains(parameter) && this.knownAddresses.containsKey(parameter)) {
                    this.usedAddresses.add(parameter);
                }
            }
            this.sourceAssembly.append("\n");
        }
    }

    public void evaluateHOME() {
        this.addAssembly(null, "JSR", "HOME");
    }

    public void evaluateTEXT() {
        this.addAssembly(null, "JSR", "TEXT");
    }

    public void evaluateRETURN() {
        this.addAssembly(null, "RTS", null);
    }

    public void evaluateEND() {
        this.evaluateRETURN();
    }

    public void evaluateHGR() {
        this.addAssembly(null, "JSR", "HGR");
    }

    public void evaluateHGR2() {
        this.addAssembly(null, "JSR", "HGR2");
    }

    public void evaluateGR() {
        this.addAssembly(null, "JSR", "GR");
    }

    public void evaluateINVERSE() {
        this.addAssembly(null, "LDA", "#$3F");
        this.addAssembly(null, "STA", "INVFLAG");
    }

    public void evaluateNORMAL() {
        this.addAssembly(null, "LDA", "#$FF");
        this.addAssembly(null, "STA", "INVFLAG");
    }

    public void evaluateFLASH() {
        this.addAssembly(null, "LDA", "#$7F");
        this.addAssembly(null, "STA", "INVFLAG");
    }

    protected Variable evaluateExpression() throws CompileException {
        ApplesoftToken token = this.peekToken();
        if (token.isEndOfCommand()) {
            return null;
        }
        token = this.nextToken();
        if (token.isString()) {
            String value = token.getStringValue();
            Variable variable = null;
            for (int i = 0; i < this.variables.size() && !value.equals((variable = this.variables.get(i)).getValue()); ++i) {
                variable = null;
            }
            if (variable == null) {
                variable = this.isIntegerNumber(value) ? new Variable("INT" + value, 5, value) : (value.startsWith("\"") ? new Variable("STR" + this.variables.size(), 4, value) : (value.endsWith("$") ? new Variable("VAR" + value, 1, value) : (value.endsWith("%") || this.isIntegerOnlyMath() ? new Variable("VAR" + value, 2, value) : new Variable("VAR" + value, 3, value))));
                this.variables.add(variable);
            }
            return variable;
        }
        throw new CompileException(this.textBundle.get("ApplesoftCompiler.UnableToEvaluateError"));
    }

    protected Variable evaluateNumber() throws CompileException {
        Variable variable = this.evaluateExpression();
        if (variable.isNumber()) {
            return variable;
        }
        throw new CompileException(this.textBundle.get("ApplesoftCompiler.NumberRequiredError"));
    }

    protected String getLineNumberLabel() throws CompileException {
        ApplesoftToken token = this.nextToken();
        if (token.isString() && this.isIntegerNumber(token.getStringValue())) {
            return "LINE" + token.getStringValue();
        }
        throw new CompileException(this.textBundle.format("ApplesoftCompiler.ExpectingLineNumberError", token.toString()));
    }

    protected void addLoadByteValue(Variable variable, char register) throws CompileException {
        if (variable.isConstantInteger()) {
            this.addAssembly(null, "LD" + register, "#" + variable.getValue());
        } else if (variable.isTypeInteger()) {
            this.addAssembly(null, "LD" + register, variable.getName());
        } else if (variable.isConstantFloat() || variable.isTypeFloat()) {
            this.addAssembly(null, "LDY", "#>" + variable.getName());
            this.addAssembly(null, "LDA", "#<" + variable.getName());
            this.addAssembly(null, "JSR", "MOVFM");
            this.addAssembly(null, "JSR", "QINT");
            this.addAssembly(null, "LD" + register, "FACLO");
        } else {
            throw new CompileException(this.textBundle.format("ApplesoftCompiler.InvalidByteFormatError", variable.getName()));
        }
    }

    protected void addLoadWordValue(Variable variable, char registerHi, char registerLo) throws CompileException {
        if (variable.isConstantInteger()) {
            this.addAssembly(null, "LD" + registerHi, "#>" + variable.getValue());
            this.addAssembly(null, "LD" + registerLo, "#<" + variable.getValue());
        } else if (variable.isTypeInteger()) {
            this.addAssembly(null, "LD" + registerHi, variable.getName() + "+1");
            this.addAssembly(null, "LD" + registerLo, variable.getName());
        } else if (variable.isConstantFloat() || variable.isTypeFloat()) {
            this.addLoadFac(variable);
            this.addAssembly(null, "JSR", "QINT");
            this.addAssembly(null, "LD" + registerHi, "FACMO");
            this.addAssembly(null, "LD" + registerLo, "FACLO");
        } else {
            throw new CompileException(this.textBundle.format("ApplesoftCompiler.InvalidWordFormatError", variable.getName()));
        }
    }

    protected void addLoadAddress(Variable variable, char registerHi, char registerLo) {
        this.addAssembly(null, "LD" + registerHi, "#>" + variable.getName());
        this.addAssembly(null, "LD" + registerLo, "#<" + variable.getName());
    }

    protected void addLoadFac(Variable variable) throws CompileException {
        if (variable.isConstantFloat() || variable.isTypeFloat()) {
            this.addLoadAddress(variable, 'Y', 'A');
            this.addAssembly(null, "JSR", "MOVFM");
        } else if (variable.isConstantInteger() || variable.isTypeInteger()) {
            this.addLoadWordValue(variable, 'A', 'Y');
            this.addAssembly(null, "JSR", "GIVAYF");
        } else {
            throw new CompileException(this.textBundle.format("ApplesoftCompiler.InvalidFloatTypeError", variable.getName()));
        }
    }

    protected void addCopyFac(Variable variable) throws CompileException {
        if (!variable.isTypeFloat()) {
            throw new CompileException(this.textBundle.get("ApplesoftCompiler.CannotCopyToFloatError"));
        }
        this.addLoadAddress(variable, 'Y', 'X');
        this.addAssembly(null, "JSR", "MOVMF");
    }

    public void evaluateHTAB() throws CompileException {
        this.addLoadByteValue(this.evaluateExpression(), 'A');
        this.addAssembly(null, "STA", "CH");
    }

    public void evaluateVTAB() throws CompileException {
        this.addLoadByteValue(this.evaluateExpression(), 'X');
        this.addAssembly(null, "DEX", null);
        this.addAssembly(null, "STX", "CV");
        this.addAssembly(null, "JSR", "LF");
    }

    public void evaluateHCOLOR() throws CompileException {
        this.addLoadByteValue(this.evaluateExpression(), 'X');
        this.addAssembly(null, "JSR", "SETHCOL");
    }

    public void evaluatePRINT() throws CompileException {
        ApplesoftToken token = null;
        do {
            Variable variable;
            if ((variable = this.evaluateExpression()) == null) {
                this.addAssembly(null, "JSR", "PRCR");
            } else if (variable.isConstantFloat() || variable.isTypeFloat()) {
                this.addLoadFac(variable);
                this.addAssembly(null, "JSR", "PRNTFAC");
            } else if (variable.isConstantInteger() || variable.isTypeInteger()) {
                this.addLoadWordValue(variable, 'X', 'A');
                this.addAssembly(null, "JSR", "LINPRT");
            } else if (variable.isConstantString()) {
                this.addLoadAddress(variable, 'Y', 'A');
                this.addAssembly(null, "JSR", "STROUT");
            } else if (variable.isTypeString()) {
                throw new CompileException(this.textBundle.get("ApplesoftCompiler.StringPrintUnsupported"));
            }
            token = this.peekToken();
            if (token == null || !token.isExpressionSeparator()) continue;
            this.nextToken();
        } while ((token = this.peekToken()) != null && !token.isEndOfCommand());
    }

    public void evaluateGOTO() throws CompileException {
        this.addAssembly(null, "JMP", this.getLineNumberLabel());
    }

    protected void checkSyntax(byte tokenValue, String expectedToken) throws CompileException {
        ApplesoftToken token = this.nextToken();
        if (token.getTokenValue() != tokenValue) {
            throw new CompileException(this.textBundle.format("ApplesoftCompiler.SyntaxError", expectedToken));
        }
    }

    protected void checkSyntax(String stringValue, String expectedToken) throws CompileException {
        ApplesoftToken token = this.nextToken();
        if (!stringValue.equals(token.getStringValue())) {
            throw new CompileException(this.textBundle.format("ApplesoftCompiler.SyntaxError", expectedToken));
        }
    }

    public void evaluateFOR() throws CompileException {
        Variable loopVariable = this.evaluateExpression();
        if (!loopVariable.isTypeFloat() && !loopVariable.isTypeInteger()) {
            throw new CompileException(this.textBundle.get("ApplesoftCompiler.ForStatementUnsupportedTypeError"));
        }
        this.checkSyntax((byte)-48, "=");
        Variable startValue = this.evaluateNumber();
        this.checkSyntax((byte)-63, "TO");
        Variable endValue = this.evaluateNumber();
        String loopName = "FOR" + this.loopVariables.size();
        this.loopVariables.add(loopName);
        this.addLoadFac(startValue);
        this.addCopyFac(loopVariable);
        this.addAssembly(loopName, null, null);
        this.addLoadFac(endValue);
        this.addLoadAddress(loopVariable, 'Y', 'A');
        this.addAssembly(null, "JSR", "FCOMP");
        this.addAssembly(null, "CMP", "#$FF");
        this.addAssembly(null, "BEQ", "END" + loopName);
    }

    public void evaluateHPLOT() throws CompileException {
        boolean firstCoordinate = true;
        while (this.peekToken() != null && !this.peekToken().isEndOfCommand()) {
            if (!firstCoordinate) {
                this.checkSyntax((byte)-63, "TO");
            }
            Variable coordX = this.evaluateNumber();
            this.checkSyntax(",", ", (comma)");
            Variable coordY = this.evaluateNumber();
            if (firstCoordinate) {
                this.addLoadWordValue(coordX, 'Y', 'X');
                this.addLoadByteValue(coordY, 'A');
                this.addAssembly(null, "JSR", "HPOSN");
                firstCoordinate = false;
                continue;
            }
            this.addLoadWordValue(coordX, 'X', 'A');
            this.addLoadByteValue(coordY, 'Y');
            this.addAssembly(null, "JSR", "HLIN");
        }
    }

    public void evaluateNEXT() throws CompileException {
        Variable variable = null;
        if (!this.peekToken().isCommandSeparator()) {
            variable = this.evaluateExpression();
        }
        if (variable.isTypeFloat()) {
            this.addAssembly(null, "LDY", "#1");
            this.addAssembly(null, "JSR", "SNGFLT");
            this.addLoadAddress(variable, 'Y', 'A');
            this.addAssembly(null, "JSR", "FADD");
            this.addCopyFac(variable);
        } else if (variable.isTypeInteger()) {
            this.addAssembly(null, "INC", variable.getName());
            this.addAssembly(null, "BNE", ":1");
            this.addAssembly(null, "INC", variable.getName() + "+1");
            this.addAssembly(":1", null, null);
        }
        String loopName = this.loopVariables.pop();
        this.addAssembly(null, "JMP", loopName);
        this.addAssembly("END" + loopName, null, null);
    }

    protected boolean isIntegerNumber(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isIntegerOnlyMath() {
        return this.integerOnlyMath;
    }

    public void setIntegerOnlyMath(boolean integerOnlyMath) {
        this.integerOnlyMath = integerOnlyMath;
    }
}

