/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.xpath.report;

import java.util.ArrayList;
import java.util.List;
import net.sf.ahtutils.test.AbstractXmlTest;
import net.sf.ahtutils.xml.report.Media;
import net.sf.ahtutils.xml.report.TestMedia;
import net.sf.ahtutils.xml.xpath.ReportXpath;
import net.sf.exlp.util.exception.ExlpXpathNotFoundException;
import net.sf.exlp.util.exception.ExlpXpathNotUniqueException;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReportMediaXpath
extends AbstractXmlTest {
    static final Logger logger = LoggerFactory.getLogger(TestReportMediaXpath.class);
    private Media media1;
    private Media media2;
    private Media media3;
    private Media media4;
    private List<Media> mediaList;

    @Before
    public void iniMedia() {
        this.media1 = TestMedia.create("t1");
        this.media1.setDir("d1");
        this.media2 = TestMedia.create("t2");
        this.media3 = TestMedia.create("t3");
        this.media4 = TestMedia.create("t3");
        this.mediaList = new ArrayList<Media>();
        this.mediaList.add(this.media1);
        this.mediaList.add(this.media2);
        this.mediaList.add(this.media3);
        this.mediaList.add(this.media4);
    }

    @Test
    public void testType1() throws ExlpXpathNotFoundException, ExlpXpathNotUniqueException {
        Media test = ReportXpath.getMedia(this.mediaList, (String)this.media1.getType());
        Assert.assertEquals((Object)JaxbUtil.toString((Object)this.media1), (Object)JaxbUtil.toString((Object)test));
    }

    @Test
    public void testType2() throws ExlpXpathNotFoundException, ExlpXpathNotUniqueException {
        Media test = ReportXpath.getMedia(this.mediaList, (String)this.media2.getType());
        Assert.assertEquals((Object)JaxbUtil.toString((Object)this.media2), (Object)JaxbUtil.toString((Object)test));
    }

    @Test(expected=ExlpXpathNotFoundException.class)
    public void testNotFound() throws ExlpXpathNotFoundException, ExlpXpathNotUniqueException {
        ReportXpath.getMedia(this.mediaList, (String)"nullCode");
    }

    @Test(expected=ExlpXpathNotUniqueException.class)
    public void testUnique() throws ExlpXpathNotFoundException, ExlpXpathNotUniqueException {
        ReportXpath.getMedia(this.mediaList, (String)this.media3.getType());
    }
}

