/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.xpath.mail;

import net.sf.ahtutils.test.AbstractXmlTest;
import net.sf.ahtutils.xml.mail.Mail;
import net.sf.ahtutils.xml.mail.Template;
import net.sf.ahtutils.xml.mail.TestXmlTemplate;
import net.sf.ahtutils.xml.xpath.MailXpath;
import net.sf.exlp.util.exception.ExlpXpathNotFoundException;
import net.sf.exlp.util.exception.ExlpXpathNotUniqueException;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMailsTemplateXpath
extends AbstractXmlTest {
    static final Logger logger = LoggerFactory.getLogger(TestMailsTemplateXpath.class);
    private Template xml1;
    private Template xml2;
    private Template xml3;
    private Template xml4;
    private Mail mail;

    @Before
    public void initXml() {
        this.mail = new Mail();
        this.xml1 = TestXmlTemplate.create("l1", "t1", false);
        this.mail.getTemplate().add(this.xml1);
        this.xml2 = TestXmlTemplate.create("l2", "t2", false);
        this.mail.getTemplate().add(this.xml2);
        this.xml3 = TestXmlTemplate.create("l3", "t3", false);
        this.mail.getTemplate().add(this.xml3);
        this.xml4 = TestXmlTemplate.create("l3", "t3", false);
        this.mail.getTemplate().add(this.xml4);
    }

    @Test
    public void testId1() throws ExlpXpathNotFoundException, ExlpXpathNotUniqueException {
        Template actual = MailXpath.getTemplate((Mail)this.mail, (String)this.xml1.getLang(), (String)this.xml1.getType());
        this.assertJaxbEquals(this.xml1, actual);
    }

    @Test
    public void testId2() throws ExlpXpathNotFoundException, ExlpXpathNotUniqueException {
        Template actual = MailXpath.getTemplate((Mail)this.mail, (String)this.xml2.getLang(), (String)this.xml2.getType());
        this.assertJaxbEquals(this.xml2, actual);
    }

    @Test(expected=ExlpXpathNotFoundException.class)
    public void testNotFound() throws ExlpXpathNotFoundException, ExlpXpathNotUniqueException {
        MailXpath.getTemplate((Mail)this.mail, (String)"nullLang", (String)"nullType");
    }

    @Test(expected=ExlpXpathNotUniqueException.class)
    public void testUnique() throws ExlpXpathNotFoundException, ExlpXpathNotUniqueException {
        MailXpath.getTemplate((Mail)this.mail, (String)this.xml3.getLang(), (String)this.xml3.getType());
    }
}

