/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.xpath.access;

import net.sf.ahtutils.test.AbstractXmlTest;
import net.sf.ahtutils.xml.access.AclContainer;
import net.sf.ahtutils.xml.access.Group;
import net.sf.ahtutils.xml.access.RoleAutoAssign;
import net.sf.ahtutils.xml.xpath.AccessXpath;
import net.sf.exlp.util.exception.ExlpXpathNotFoundException;
import net.sf.exlp.util.exception.ExlpXpathNotUniqueException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXPathAccessAutoAssign
extends AbstractXmlTest {
    static final Logger logger = LoggerFactory.getLogger(TestXPathAccessAutoAssign.class);
    private AclContainer aclContainer;
    private final String code = "code";

    @Before
    public void iniAclContainer() {
        RoleAutoAssign raa = new RoleAutoAssign();
        raa.setCode("code");
        RoleAutoAssign.Add add = new RoleAutoAssign.Add();
        Group g1 = new Group();
        g1.setCode("g1");
        add.getGroup().add(g1);
        Group g2 = new Group();
        g2.setCode("g2");
        add.getGroup().add(g2);
        RoleAutoAssign.Rm rm = new RoleAutoAssign.Rm();
        rm.setImmediate(false);
        Group g3 = new Group();
        g3.setCode("g3");
        rm.getGroup().add(g3);
        Group g4 = new Group();
        g4.setCode("g4");
        rm.getGroup().add(g4);
        raa.setAdd(add);
        raa.setRm(rm);
        this.aclContainer = new AclContainer();
        this.aclContainer.getRoleAutoAssign().add(raa);
    }

    @Test
    public void find() throws ExlpXpathNotFoundException, ExlpXpathNotUniqueException {
        RoleAutoAssign test = AccessXpath.getAutoAssign((AclContainer)this.aclContainer, (String)"code");
        Assert.assertEquals((Object)"code", (Object)test.getCode());
    }

    @Test(expected=ExlpXpathNotFoundException.class)
    public void testNotFound() throws ExlpXpathNotFoundException, ExlpXpathNotUniqueException {
        AccessXpath.getAutoAssign((AclContainer)this.aclContainer, (String)"-1");
    }
}

