/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.status;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.status.AbstractXmlStatusTest;
import net.sf.ahtutils.xml.status.TestXmlTranslation;
import net.sf.ahtutils.xml.status.Translations;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlTranslations
extends AbstractXmlStatusTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlTranslations.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/status", "translations.xml");
    }

    @Test
    public void testXml() throws FileNotFoundException {
        Translations actual = TestXmlTranslations.create();
        Translations expected = (Translations)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Translations.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Translations create() {
        return TestXmlTranslations.create(true);
    }

    public static Translations create(boolean withChilds) {
        Translations xml = new Translations();
        if (withChilds) {
            xml.getTranslation().add(TestXmlTranslation.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlTranslations.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlTranslations.initFiles();
        TestXmlTranslations test = new TestXmlTranslations();
        test.save();
    }
}

