/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.status;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.status.AbstractXmlStatusTest;
import net.sf.ahtutils.xml.status.TestXmlDescriptions;
import net.sf.ahtutils.xml.status.TestXmlLangs;
import net.sf.ahtutils.xml.status.TestXmlTranslations;
import net.sf.ahtutils.xml.status.Translation;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlTranslation
extends AbstractXmlStatusTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlTranslations.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/status", "translation.xml");
    }

    @Test
    public void testXml() throws FileNotFoundException {
        Translation actual = TestXmlTranslation.create();
        Translation expected = (Translation)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Translation.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Translation create() {
        return TestXmlTranslation.create(true);
    }

    public static Translation create(boolean withChilds) {
        Translation xml = new Translation();
        xml.setKey("myKey");
        if (withChilds) {
            xml.setDescriptions(TestXmlDescriptions.create(false));
            xml.setLangs(TestXmlLangs.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlTranslation.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlTranslation.initFiles();
        TestXmlTranslation test = new TestXmlTranslation();
        test.save();
    }
}

