/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.status;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.status.AbstractXmlStatusTest;
import net.sf.ahtutils.xml.status.Lang;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlLang
extends AbstractXmlStatusTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlLang.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/status", "lang.xml");
    }

    @Test
    public void testXml() throws FileNotFoundException {
        Lang actual = TestXmlLang.create();
        Lang expected = (Lang)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Lang.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Lang create() {
        return TestXmlLang.create(true);
    }

    public static Lang create(boolean withChilds) {
        return TestXmlLang.create(withChilds, "myKey", "myTranslation");
    }

    public static Lang create(boolean withChilds, String key, String translation) {
        Lang xml = new Lang();
        xml.setKey(key);
        xml.setTranslation(translation);
        return xml;
    }

    public void save() {
        this.save(TestXmlLang.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlLang.initFiles();
        TestXmlLang test = new TestXmlLang();
        test.save();
    }
}

