/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.status;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.status.AbstractXmlStatusTest;
import net.sf.ahtutils.xml.status.Description;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlDescription
extends AbstractXmlStatusTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlDescription.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/status", "description.xml");
    }

    @Test
    public void testXml() throws FileNotFoundException {
        Description actual = TestXmlDescription.create();
        Description expected = (Description)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Description.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Description create() {
        return TestXmlDescription.create(true);
    }

    public static Description create(boolean withChilds) {
        return TestXmlDescription.create(withChilds, "myKey", "myValue");
    }

    public static Description create(boolean withChilds, String key, String description) {
        Description xml = new Description();
        xml.setKey(key);
        xml.setValue(description);
        return xml;
    }

    public void save() {
        this.save(TestXmlDescription.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlDescription.initFiles();
        TestXmlDescription test = new TestXmlDescription();
        test.save();
    }
}

