/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.report;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.report.AbstractXmlReportTest;
import net.sf.ahtutils.xml.report.Resource;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResource
extends AbstractXmlReportTest {
    static final Logger logger = LoggerFactory.getLogger(TestResource.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/report", "resource.xml");
    }

    @Test
    public void testResource() throws FileNotFoundException {
        Resource test = TestResource.create();
        Resource ref = (Resource)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Resource.class);
        this.assertJaxbEquals(ref, test);
    }

    public static Resource create() {
        Resource resource = new Resource();
        resource.setName("logo");
        resource.setType("image");
        Resource.Value myValue = new Resource.Value();
        myValue.setValue("logo.png");
        resource.setValue(myValue);
        return resource;
    }

    public void save() {
        this.save(TestResource.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestResource.initPrefixMapper();
        TestResource.initFiles();
        TestResource test = new TestResource();
        test.save();
    }
}

