/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.report;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.report.AbstractXmlReportTest;
import net.sf.ahtutils.xml.report.Report;
import net.sf.ahtutils.xml.report.TestMedia;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReport
extends AbstractXmlReportTest {
    static final Logger logger = LoggerFactory.getLogger(TestReport.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/report", "report.xml");
    }

    @Test
    public void testReport() throws FileNotFoundException {
        Report test = TestReport.create();
        Report ref = (Report)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Report.class);
        this.assertJaxbEquals(ref, test);
    }

    public static Report create() {
        return TestReport.create("testReportId");
    }

    public static Report create(String id) {
        Report report = new Report();
        report.setId(id);
        report.setDir("testDir");
        report.setExample("testExampleXmlFile");
        report.getMedia().add(TestMedia.create("pdf"));
        report.getMedia().add(TestMedia.create("xls"));
        report.setLtr(true);
        report.setRtl(false);
        return report;
    }

    public void save() {
        this.save(TestReport.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestReport.initPrefixMapper();
        TestReport.initFiles();
        TestReport test = new TestReport();
        test.save();
    }
}

