/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.report;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import net.sf.ahtutils.xml.report.AbstractXmlReportTest;
import net.sf.ahtutils.xml.report.Info;
import net.sf.exlp.util.DateUtil;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInfo
extends AbstractXmlReportTest {
    static final Logger logger = LoggerFactory.getLogger(TestInfo.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/report", "info.xml");
    }

    @Test
    public void testInfo() throws FileNotFoundException {
        Info test = TestInfo.create();
        Info ref = (Info)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Info.class);
        this.assertJaxbEquals(ref, test);
    }

    public static Info create() {
        Info info = new Info();
        Info.Title title = new Info.Title();
        title.setValue("testTitle");
        info.setTitle(title);
        Info.Subtitle subtitle = new Info.Subtitle();
        subtitle.setValue("testSubTitle");
        info.setSubtitle(subtitle);
        Info.Footer footer = new Info.Footer();
        footer.setValue("testFooter");
        info.setFooter(footer);
        Info.Record record = new Info.Record();
        record.setValue(DateUtil.getXmlGc4D((Date)TestInfo.getDefaultDate()));
        info.setRecord(record);
        return info;
    }

    public void save() {
        this.save(TestInfo.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestInfo.initPrefixMapper();
        TestInfo.initFiles();
        TestInfo test = new TestInfo();
        test.save();
    }
}

