/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.mail;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.mail.AbstractXmlMailTest;
import net.sf.ahtutils.xml.mail.Tracker;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlTracker
extends AbstractXmlMailTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlTracker.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/mail", "tracker.xml");
    }

    @Test
    public void xml() throws FileNotFoundException {
        Tracker actual = TestXmlTracker.create();
        Tracker expected = (Tracker)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Tracker.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Tracker create() {
        return TestXmlTracker.create(true);
    }

    public static Tracker create(boolean withChilds) {
        Tracker xml = new Tracker();
        xml.setId(123L);
        xml.setRefId(345L);
        xml.setType("myType");
        xml.setCreated(TestXmlTracker.getXmlDefaultDate());
        xml.setSent(TestXmlTracker.getXmlDefaultDate());
        xml.setRetryCounter(1);
        return xml;
    }

    public void save() {
        this.save(TestXmlTracker.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlTracker.initPrefixMapper();
        TestXmlTracker.initFiles();
        TestXmlTracker test = new TestXmlTracker();
        test.save();
    }
}

