/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.mail;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.mail.AbstractXmlMailTest;
import net.sf.ahtutils.xml.mail.Template;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlTemplate
extends AbstractXmlMailTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlTemplate.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/mail", "template.xml");
    }

    @Test
    public void xml() throws FileNotFoundException {
        Template actual = TestXmlTemplate.create();
        Template expected = (Template)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Template.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Template create() {
        return TestXmlTemplate.create(true);
    }

    public static Template create(boolean withChilds) {
        return TestXmlTemplate.create("myLang", "myType", withChilds);
    }

    public static Template create(String lang, String type, boolean withChilds) {
        Template xml = new Template();
        xml.setFile("myFile");
        xml.setLang(lang);
        xml.setType(type);
        return xml;
    }

    public void save() {
        this.save(TestXmlTemplate.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlTemplate.initPrefixMapper();
        TestXmlTemplate.initFiles();
        TestXmlTemplate test = new TestXmlTemplate();
        test.save();
    }
}

