/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.mail;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.mail.AbstractXmlMailTest;
import net.sf.ahtutils.xml.mail.Mails;
import net.sf.ahtutils.xml.mail.TestXmlMail;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlMails
extends AbstractXmlMailTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlMails.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/mail", "mails.xml");
    }

    @Test
    public void xml() throws FileNotFoundException {
        Mails actual = TestXmlMails.create();
        Mails expected = (Mails)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Mails.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Mails create() {
        return TestXmlMails.create(true);
    }

    public static Mails create(boolean withChilds) {
        Mails xml = new Mails();
        xml.setDir("myDir");
        if (withChilds) {
            xml.getMail().add(TestXmlMail.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlMails.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlMails.initPrefixMapper();
        TestXmlMails.initFiles();
        TestXmlMails test = new TestXmlMails();
        test.save();
    }
}

