/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.mail;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.mail.AbstractXmlMailTest;
import net.sf.ahtutils.xml.mail.Header;
import net.sf.ahtutils.xml.mail.TestXmlBcc;
import net.sf.ahtutils.xml.mail.TestXmlCc;
import net.sf.ahtutils.xml.mail.TestXmlFrom;
import net.sf.ahtutils.xml.mail.TestXmlTo;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlHeader
extends AbstractXmlMailTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlHeader.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/mail", "header.xml");
    }

    @Test
    public void xml() throws FileNotFoundException {
        Header actual = TestXmlHeader.createHeader();
        Header expected = (Header)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Header.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Header createHeader() {
        return TestXmlHeader.createHeader(true);
    }

    public static Header createHeader(boolean withChilds) {
        Header xml = new Header();
        xml.setSubject("mySubject");
        if (withChilds) {
            xml.setFrom(TestXmlFrom.createFrom(false));
            xml.setTo(TestXmlTo.create(false));
            xml.setCc(TestXmlCc.create(false));
            xml.setBcc(TestXmlBcc.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlHeader.createHeader(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlHeader.initPrefixMapper();
        TestXmlHeader.initFiles();
        TestXmlHeader test = new TestXmlHeader();
        test.save();
    }
}

