/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.mail;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.mail.AbstractXmlMailTest;
import net.sf.ahtutils.xml.mail.From;
import net.sf.ahtutils.xml.mail.TestXmlEmailAddress;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlFrom
extends AbstractXmlMailTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlFrom.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/mail", "from.xml");
    }

    @Test
    public void xml() throws FileNotFoundException {
        From actual = TestXmlFrom.createFrom();
        From expected = (From)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), From.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static From createFrom() {
        return TestXmlFrom.createFrom(true);
    }

    public static From createFrom(boolean withChilds) {
        From xml = new From();
        if (withChilds) {
            xml.setEmailAddress(TestXmlEmailAddress.createEmailAddress(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlFrom.createFrom(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlFrom.initPrefixMapper();
        TestXmlFrom.initFiles();
        TestXmlFrom test = new TestXmlFrom();
        test.save();
    }
}

