/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.mail;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.mail.AbstractXmlMailTest;
import net.sf.ahtutils.xml.mail.EmailAddress;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlEmailAddress
extends AbstractXmlMailTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlEmailAddress.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/mail", "emailAddress.xml");
    }

    @Test
    public void xml() throws FileNotFoundException {
        EmailAddress actual = TestXmlEmailAddress.createEmailAddress();
        EmailAddress expected = (EmailAddress)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), EmailAddress.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static EmailAddress createEmailAddress() {
        return TestXmlEmailAddress.createEmailAddress(true);
    }

    public static EmailAddress createEmailAddress(boolean withChilds) {
        EmailAddress xml = new EmailAddress();
        xml.setName("myName");
        xml.setEmail("my@e.mail");
        return xml;
    }

    public void save() {
        this.save(TestXmlEmailAddress.createEmailAddress(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlEmailAddress.initPrefixMapper();
        TestXmlEmailAddress.initFiles();
        TestXmlEmailAddress test = new TestXmlEmailAddress();
        test.save();
    }
}

