/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.mail;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.mail.AbstractXmlMailTest;
import net.sf.ahtutils.xml.mail.Bcc;
import net.sf.ahtutils.xml.mail.TestXmlEmailAddress;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlBcc
extends AbstractXmlMailTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlBcc.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/mail", "bcc.xml");
    }

    @Test
    public void xml() throws FileNotFoundException {
        Bcc actual = TestXmlBcc.create();
        Bcc expected = (Bcc)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Bcc.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Bcc create() {
        return TestXmlBcc.create(true);
    }

    public static Bcc create(boolean withChilds) {
        Bcc xml = new Bcc();
        if (withChilds) {
            xml.getEmailAddress().add(TestXmlEmailAddress.createEmailAddress(false));
            xml.getEmailAddress().add(TestXmlEmailAddress.createEmailAddress(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlBcc.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlBcc.initPrefixMapper();
        TestXmlBcc.initFiles();
        TestXmlBcc test = new TestXmlBcc();
        test.save();
    }
}

