/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.mail;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.mail.AbstractXmlMailTest;
import net.sf.ahtutils.xml.mail.Attachment;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlAttachment
extends AbstractXmlMailTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlAttachment.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/mail", "attachment.xml");
    }

    @Test
    public void xml() throws FileNotFoundException {
        Attachment actual = TestXmlAttachment.create();
        Attachment expected = (Attachment)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Attachment.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Attachment create() {
        return TestXmlAttachment.create(true);
    }

    public static Attachment create(boolean withChilds) {
        Attachment xml = new Attachment();
        if (withChilds) {
            xml.setData("myBinaryData".getBytes());
            xml.setFile(new net.sf.exlp.xml.io.File());
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlAttachment.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlAttachment.initPrefixMapper();
        TestXmlAttachment.initFiles();
        TestXmlAttachment test = new TestXmlAttachment();
        test.save();
    }
}

