/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.dbseed;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.dbseed.AbstractXmlDbseedTest;
import net.sf.ahtutils.xml.dbseed.Db;
import net.sf.ahtutils.xml.dbseed.TestSeed;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDb
extends AbstractXmlDbseedTest {
    static final Logger logger = LoggerFactory.getLogger(AbstractXmlDbseedTest.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/dbseed", "db.xml");
    }

    @Test
    public void xml() throws FileNotFoundException {
        Db actual = TestDb.create();
        Db expected = (Db)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Db.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Db create() {
        return TestDb.create(true);
    }

    public static Db create(boolean withChilds) {
        Db xml = new Db();
        xml.setPath("myPath");
        if (withChilds) {
            xml.getSeed().add(TestSeed.createSeed(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestDb.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestDb.initPrefixMapper();
        TestDb.initFiles();
        TestDb test = new TestDb();
        test.save();
    }
}

