/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.cloud.facebook;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.cloud.facebook.AbstractXmlFacebookTest;
import net.sf.ahtutils.xml.cloud.facebook.SignedRequest;
import net.sf.ahtutils.xml.cloud.facebook.TestXmlOauth;
import net.sf.ahtutils.xml.cloud.facebook.TestXmlUser;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlSignedRequest
extends AbstractXmlFacebookTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlSignedRequest.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/cloud/facebook", "signedRequest.xml");
    }

    @Test
    public void testApp() throws FileNotFoundException {
        SignedRequest actual = this.create();
        SignedRequest expected = (SignedRequest)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), SignedRequest.class);
        this.assertJaxbEquals(expected, actual);
    }

    private SignedRequest create() {
        return this.create(false);
    }

    public SignedRequest create(boolean withChilds) {
        SignedRequest xml = new SignedRequest();
        xml.setExpires(TestXmlSignedRequest.getXmlDefaultDate());
        xml.setIssuedAt(TestXmlSignedRequest.getXmlDefaultDate());
        if (withChilds) {
            xml.setOauth(TestXmlOauth.create(false));
            xml.setUser(TestXmlUser.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(this.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlSignedRequest.initFiles();
        TestXmlSignedRequest test = new TestXmlSignedRequest();
        test.save();
    }
}

