/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.cloud.facebook;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.cloud.facebook.AbstractXmlFacebookTest;
import net.sf.ahtutils.xml.cloud.facebook.App;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import net.sf.exlp.xml.net.Url;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlApp
extends AbstractXmlFacebookTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlApp.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/cloud/facebook", "app.xml");
    }

    @Test
    public void testApp() throws FileNotFoundException {
        App actual = this.create();
        App expected = (App)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), App.class);
        this.assertJaxbEquals(expected, actual);
    }

    private App create() {
        return this.create(true);
    }

    public App create(boolean withChilds) {
        App xml = new App();
        xml.setAppId("123");
        xml.setScope("myScope");
        xml.setSecret("mySecret");
        App.Redirect redirect = new App.Redirect();
        Url url = new Url();
        url.setCode("myCode");
        url.setValue("http://my.app");
        redirect.getUrl().add(url);
        xml.setRedirect(redirect);
        return xml;
    }

    public void save() {
        this.save(this.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlApp test = new TestXmlApp();
        test.save();
    }
}

