/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.aht;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.TestXmlRole;
import net.sf.ahtutils.xml.aht.AbstractXmlAhtTest;
import net.sf.ahtutils.xml.aht.Query;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestQuery
extends AbstractXmlAhtTest {
    static final Logger logger = LoggerFactory.getLogger(TestQuery.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/aht", "query.xml");
    }

    @Test
    public void xml() throws FileNotFoundException {
        Query actual = TestQuery.create();
        Query expected = (Query)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Query.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Query create() {
        return TestQuery.create(true);
    }

    public static Query create(boolean withChilds) {
        Query xml = new Query();
        xml.setLang("myLang");
        if (withChilds) {
            xml.setRole(TestXmlRole.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestQuery.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestQuery.initPrefixMapper();
        TestQuery.initFiles();
        TestQuery test = new TestQuery();
        test.save();
    }
}

