/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.TestXmlView;
import net.sf.ahtutils.xml.access.Views;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlViews
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlViews.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "views.xml");
    }

    @Test
    public void testAclContainer() throws FileNotFoundException {
        Views actual = TestXmlViews.create();
        Views expected = (Views)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Views.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Views create() {
        return TestXmlViews.create(true);
    }

    public static Views create(boolean withChilds) {
        Views xml = new Views();
        if (withChilds) {
            xml.getView().add(TestXmlView.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlViews.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlViews.initFiles();
        TestXmlViews test = new TestXmlViews();
        test.save();
    }
}

