/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.TestXmlActions;
import net.sf.ahtutils.xml.access.View;
import net.sf.ahtutils.xml.status.TestXmlDescriptions;
import net.sf.ahtutils.xml.status.TestXmlLangs;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlView
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlView.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "view.xml");
    }

    @Test
    public void testAclContainer() throws FileNotFoundException {
        View actual = TestXmlView.create();
        View expected = (View)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), View.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static View create() {
        return TestXmlView.create(true);
    }

    public static View create(boolean withChilds) {
        View xml = new View();
        xml.setCode("myCode");
        xml.setIndex(1);
        if (withChilds) {
            xml.setLangs(TestXmlLangs.create(false));
            xml.setDescriptions(TestXmlDescriptions.create(false));
            xml.setActions(TestXmlActions.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlView.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlView.initFiles();
        TestXmlView test = new TestXmlView();
        test.save();
    }
}

