/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.TestXmlUsecase;
import net.sf.ahtutils.xml.access.Usecases;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlUsecases
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlUsecases.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "usecases.xml");
    }

    @Test
    public void testAclContainer() throws FileNotFoundException {
        Usecases actual = TestXmlUsecases.create();
        Usecases expected = (Usecases)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Usecases.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Usecases create() {
        return TestXmlUsecases.create(true);
    }

    public static Usecases create(boolean withChilds) {
        Usecases xml = new Usecases();
        if (withChilds) {
            xml.getUsecase().add(TestXmlUsecase.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlUsecases.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlUsecases.initFiles();
        TestXmlUsecases test = new TestXmlUsecases();
        test.save();
    }
}

