/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.TestXmlActions;
import net.sf.ahtutils.xml.access.TestXmlViews;
import net.sf.ahtutils.xml.access.Usecase;
import net.sf.ahtutils.xml.status.TestXmlDescriptions;
import net.sf.ahtutils.xml.status.TestXmlLangs;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlUsecase
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlUsecase.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "usecase.xml");
    }

    @Test
    public void testAclContainer() throws FileNotFoundException {
        Usecase actual = TestXmlUsecase.create();
        Usecase expected = (Usecase)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Usecase.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Usecase create() {
        return TestXmlUsecase.create(true);
    }

    public static Usecase create(boolean withChilds) {
        Usecase xml = new Usecase();
        xml.setCode("myCode");
        if (withChilds) {
            xml.setLangs(TestXmlLangs.create(false));
            xml.setDescriptions(TestXmlDescriptions.create(false));
            xml.setActions(TestXmlActions.create(false));
            xml.setViews(TestXmlViews.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlUsecase.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlUsecase.initFiles();
        TestXmlUsecase test = new TestXmlUsecase();
        test.save();
    }
}

