/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.Roles;
import net.sf.ahtutils.xml.access.TestXmlRole;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlRoles
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlRoles.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "roles.xml");
    }

    @Test
    public void testAclContainer() throws FileNotFoundException {
        Roles actual = TestXmlRoles.create();
        Roles expected = (Roles)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Roles.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Roles create() {
        return TestXmlRoles.create(true);
    }

    public static Roles create(boolean withChilds) {
        Roles xml = new Roles();
        if (withChilds) {
            xml.getRole().add(TestXmlRole.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlRoles.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlRoles.initFiles();
        TestXmlRoles test = new TestXmlRoles();
        test.save();
    }
}

