/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.Role;
import net.sf.ahtutils.xml.access.TestXmlActions;
import net.sf.ahtutils.xml.access.TestXmlUsecases;
import net.sf.ahtutils.xml.access.TestXmlViews;
import net.sf.ahtutils.xml.status.TestXmlDescriptions;
import net.sf.ahtutils.xml.status.TestXmlLangs;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlRole
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlRole.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "role.xml");
    }

    @Test
    public void testXml() throws FileNotFoundException {
        Role actual = TestXmlRole.create();
        Role expected = (Role)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Role.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Role create() {
        return TestXmlRole.create(true);
    }

    public static Role create(boolean withChilds) {
        Role xml = new Role();
        xml.setCode("myCode");
        xml.setName("myName");
        if (withChilds) {
            xml.setLangs(TestXmlLangs.create(false));
            xml.setDescriptions(TestXmlDescriptions.create(false));
            xml.setActions(TestXmlActions.create(false));
            xml.setViews(TestXmlViews.create(false));
            xml.setUsecases(TestXmlUsecases.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlRole.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlRole.initFiles();
        TestXmlRole test = new TestXmlRole();
        test.save();
    }
}

