/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.Groups;
import net.sf.ahtutils.xml.access.TestXmlGroup;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlGroups
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlGroups.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "groups.xml");
    }

    @Test
    public void testAclContainer() throws FileNotFoundException {
        Groups actual = TestXmlGroups.create();
        Groups expected = (Groups)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Groups.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Groups create() {
        return TestXmlGroups.create(true);
    }

    public static Groups create(boolean withChilds) {
        Groups xml = new Groups();
        if (withChilds) {
            xml.getGroup().add(TestXmlGroup.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlGroups.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlGroups.initFiles();
        TestXmlGroups test = new TestXmlGroups();
        test.save();
    }
}

