/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.Group;
import net.sf.ahtutils.xml.access.TestXmlGroups;
import net.sf.ahtutils.xml.access.TestXmlViews;
import net.sf.ahtutils.xml.status.TestXmlDescriptions;
import net.sf.ahtutils.xml.status.TestXmlLangs;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlGroup
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlGroup.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "group.xml");
    }

    @Test
    public void testAclContainer() throws FileNotFoundException {
        Group actual = TestXmlGroup.create();
        Group expected = (Group)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Group.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Group create() {
        return TestXmlGroup.create(true);
    }

    public static Group create(boolean withChilds) {
        Group xml = new Group();
        xml.setCode("myCode");
        if (withChilds) {
            xml.setLangs(TestXmlLangs.create(false));
            xml.setDescriptions(TestXmlDescriptions.create(false));
            xml.setViews(TestXmlViews.create(false));
            xml.setGroups(TestXmlGroups.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlGroup.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlGroup.initFiles();
        TestXmlGroup test = new TestXmlGroup();
        test.save();
    }
}

