/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.Category;
import net.sf.ahtutils.xml.access.TestXmlGroups;
import net.sf.ahtutils.xml.access.TestXmlRoles;
import net.sf.ahtutils.xml.access.TestXmlUsecases;
import net.sf.ahtutils.xml.access.TestXmlViews;
import net.sf.ahtutils.xml.status.TestXmlDescriptions;
import net.sf.ahtutils.xml.status.TestXmlLangs;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlCategory
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlCategory.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "category.xml");
    }

    @Test
    public void testXml() throws FileNotFoundException {
        Category actual = TestXmlCategory.create();
        Category expected = (Category)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Category.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Category create() {
        return TestXmlCategory.create(true);
    }

    public static Category create(boolean withChilds) {
        Category xml = new Category();
        xml.setCode("myCode");
        xml.setIndex(1);
        if (withChilds) {
            xml.setLangs(TestXmlLangs.create(false));
            xml.setDescriptions(TestXmlDescriptions.create(false));
            xml.setRoles(TestXmlRoles.create(false));
            xml.setGroups(TestXmlGroups.create(false));
            xml.setViews(TestXmlViews.create(false));
            xml.setUsecases(TestXmlUsecases.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlCategory.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlCategory.initFiles();
        TestXmlCategory test = new TestXmlCategory();
        test.save();
    }
}

