/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.Actions;
import net.sf.ahtutils.xml.access.TestXmlAction;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlActions
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlActions.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "actions.xml");
    }

    @Test
    public void testAclContainer() throws FileNotFoundException {
        Actions actual = TestXmlActions.create();
        Actions expected = (Actions)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Actions.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Actions create() {
        return TestXmlActions.create(true);
    }

    public static Actions create(boolean withChilds) {
        Actions xml = new Actions();
        if (withChilds) {
            xml.getAction().add(TestXmlAction.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlActions.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlActions.initFiles();
        TestXmlActions test = new TestXmlActions();
        test.save();
    }
}

