/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.Action;
import net.sf.ahtutils.xml.status.TestXmlDescriptions;
import net.sf.ahtutils.xml.status.TestXmlLangs;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlAction
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlAction.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "action.xml");
    }

    @Test
    public void testAclContainer() throws FileNotFoundException {
        Action actual = TestXmlAction.create();
        Action expected = (Action)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Action.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Action create() {
        return TestXmlAction.create(true);
    }

    public static Action create(boolean withChilds) {
        Action xml = new Action();
        xml.setCode("myCode");
        if (withChilds) {
            xml.setLangs(TestXmlLangs.create(false));
            xml.setDescriptions(TestXmlDescriptions.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlAction.create(), fXml);
    }

    public static void main(String[] args) {
        LoggerInit loggerInit = new LoggerInit("log4j.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
        TestXmlAction.initFiles();
        TestXmlAction test = new TestXmlAction();
        test.save();
    }
}

