/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.xml.access;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.ahtutils.test.UtilsXmlTstBootstrap;
import net.sf.ahtutils.xml.access.AbstractXmlAccessTest;
import net.sf.ahtutils.xml.access.Access;
import net.sf.ahtutils.xml.access.TestXmlCategory;
import net.sf.exlp.util.xml.JaxbUtil;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestXmlAccessContainer
extends AbstractXmlAccessTest {
    static final Logger logger = LoggerFactory.getLogger(TestXmlAccessContainer.class);

    @BeforeClass
    public static void initFiles() {
        fXml = new File("src/test/resources/data/xml/access", "access.xml");
    }

    @Test
    public void testAclContainer() throws FileNotFoundException {
        Access actual = TestXmlAccessContainer.create();
        Access expected = (Access)JaxbUtil.loadJAXB((String)fXml.getAbsolutePath(), Access.class);
        this.assertJaxbEquals(expected, actual);
    }

    private static Access create() {
        return TestXmlAccessContainer.create(true);
    }

    public static Access create(boolean withChilds) {
        Access xml = new Access();
        if (withChilds) {
            xml.getCategory().add(TestXmlCategory.create(false));
        }
        return xml;
    }

    public void save() {
        this.save(TestXmlAccessContainer.create(), fXml);
    }

    public static void main(String[] args) {
        UtilsXmlTstBootstrap.init();
        TestXmlAccessContainer.initFiles();
        TestXmlAccessContainer test = new TestXmlAccessContainer();
        test.save();
    }
}

