/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.test;

import java.io.File;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import net.sf.ahtutils.xml.ns.AhtUtilsNsPrefixMapper;
import net.sf.exlp.util.DateUtil;
import net.sf.exlp.util.io.LoggerInit;
import net.sf.exlp.util.xml.JaxbUtil;
import net.sf.exlp.xml.ns.NsPrefixMapperInterface;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlTest {
    static final Logger logger = LoggerFactory.getLogger(AbstractXmlTest.class);
    protected static NsPrefixMapperInterface nsPrefixMapper;

    @BeforeClass
    public static void initPrefixMapper() {
        nsPrefixMapper = new AhtUtilsNsPrefixMapper();
    }

    @BeforeClass
    public static void initLogger() {
        LoggerInit loggerInit = new LoggerInit("log4junit.xml");
        loggerInit.addAltPath("src/test/resources/config");
        loggerInit.init();
    }

    protected void assertJaxbEquals(Object expected, Object actual) {
        Assert.assertEquals((Object)JaxbUtil.toString((Object)expected), (Object)JaxbUtil.toString((Object)actual));
    }

    protected static XMLGregorianCalendar getXmlDefaultDate() {
        return DateUtil.getXmlGc4D((Date)AbstractXmlTest.getDefaultDate());
    }

    protected static Date getDefaultDate() {
        return DateUtil.getDateFromInt((int)2011, (int)11, (int)11, (int)11, (int)11, (int)11);
    }

    protected NsPrefixMapperInterface getPrefixMapper() {
        if (nsPrefixMapper == null) {
            nsPrefixMapper = new AhtUtilsNsPrefixMapper();
        }
        return nsPrefixMapper;
    }

    protected void save(Object xml, File f) {
        logger.debug("Saving Reference XML");
        JaxbUtil.debug2(this.getClass(), (Object)xml, (Object)this.getPrefixMapper());
        JaxbUtil.save((File)f, (Object)xml, (Object)this.getPrefixMapper(), (boolean)true);
    }
}

