/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.swagger;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.aguacate.AguacateServlet;
import net.sf.aguacate.swagger.configuration.SwaggerConfigurationCoupling;
import net.sf.aguacate.util.meta.Meta;
import net.sf.aguacate.util.meta.MetaCoupling;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AguacateSwaggerServlet
extends HttpServlet {
    private static final long serialVersionUID = 3534985525342204442L;
    private static final Logger LOGGER = LogManager.getLogger(AguacateSwaggerServlet.class);
    private static final Logger LOGGER2 = LogManager.getLogger((String)"aguacate.init");
    private static final String EXTENSION = ".yaml";
    private static final int EXTENSION_LENGTH = 5;

    public void init() throws ServletException {
        super.init();
        String group = "net.sf.aguacate.swagger";
        String artifact = "aguacate-servlet-swagger";
        Meta meta = MetaCoupling.get(AguacateServlet.class, (String)group, (String)artifact);
        String message = group + " & " + artifact + " & " + meta.getVersion();
        this.log(message);
        LOGGER2.info(message);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String originalName = request.getServletPath().substring(1);
            if (originalName.indexOf(47) < 0 && originalName.endsWith(EXTENSION)) {
                String name = originalName.substring(0, originalName.length() - 5);
                LOGGER.trace("{} -> {}", (Object)originalName, (Object)name);
                String configuration = SwaggerConfigurationCoupling.getConfiguration(name);
                if (configuration == null) {
                    response.setStatus(404);
                } else {
                    response.setStatus(200);
                    this.writeSingleString(response, configuration);
                }
            } else {
                response.setStatus(404);
            }
        }
        catch (IOException | RuntimeException e) {
            response.setStatus(500);
            LOGGER.error("on servlet", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeSingleString(HttpServletResponse response, String configuration) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        response.setContentType("text/x-yaml");
        PrintWriter writer = response.getWriter();
        try {
            ((Writer)writer).write(configuration);
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException e) {
                LOGGER.warn("on close resource", (Throwable)e);
            }
        }
    }

    static {
        assert (5 == EXTENSION.length());
    }
}

