/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.swagger.configuration.spi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.config.ConfigurationCoupling;
import net.sf.aguacate.swagger.configuration.SwaggerConfiguration;
import net.sf.aguacate.swagger.configuration.SwaggerConfigurationCoupling;
import net.sf.aguacate.util.codec.bridge.CodecCoupling;
import net.sf.aguacate.util.dynamic.bridge.Dynamic;
import net.sf.aguacate.util.dynamic.bridge.DynamicFactoryCoupling;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwaggerConfigurationSpi
implements SwaggerConfiguration {
    private static final Logger LOGGER = LogManager.getFormatterLogger(SwaggerConfigurationCoupling.class);
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String JS_FILENAME = "convert.js";
    private static final String EXTENSION = "js";
    private static final String SUFFIX = ".json";
    private static final String ENVIRONMENT = "DIRECTORY_SWAGGER";
    private static final File DIRECTORY;
    private static final Dynamic DYNAMIC;
    private final ResourceLocator locator = DIRECTORY == null ? new ResourceLocatorClassImpl(SwaggerConfigurationCoupling.class) : new ResourceLocatorFileImpl(DIRECTORY);

    @Override
    public String getConfiguration(String name) {
        try {
            String swagger = this.loadSwagger(name);
            if (swagger == null) {
                return null;
            }
            String[] parameters = this.parameters(swagger);
            LOGGER.trace("before script");
            String result = (String)DYNAMIC.typedExec("convert", new Object[]{swagger, parameters});
            LOGGER.trace("after script");
            return YAML_MAPPER.writeValueAsString((Object)CodecCoupling.jsonCodecBridge().decodeMap(result));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    String[] parameters(String swagger) throws IOException {
        Map conf = CodecCoupling.jsonCodecBridge().decodeMap(swagger);
        List entities = (List)conf.get("entities");
        int size = entities.size();
        String[] params = new String[size];
        for (int i = 0; i < size; ++i) {
            String name = (String)entities.get(i);
            String string = this.loadConfiguration(name);
            if (string == null) {
                throw new IllegalStateException(name);
            }
            params[i] = string;
        }
        return params;
    }

    String toString(String filename) throws IOException {
        InputStream inputStream = this.locator.open(filename);
        if (inputStream == null) {
            throw new IllegalStateException("not found ".concat(filename));
        }
        return this.toString(inputStream);
    }

    String loadSwagger(String name) throws IOException {
        String filename = name.concat(SUFFIX);
        LOGGER.debug(filename);
        return this.load0(this.locator, filename);
    }

    String loadConfiguration(String name) throws IOException {
        String filename = name.concat(SUFFIX);
        LOGGER.debug(filename);
        return this.load0(ConfigurationCoupling.get().getLocator(), filename);
    }

    String load0(ResourceLocator localLocator, String filename) throws IOException {
        InputStream inputStream = localLocator.open(filename);
        if (inputStream == null) {
            return null;
        }
        return this.toString(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toString(InputStream inputStream) throws IOException {
        try {
            String string = IOUtils.toString((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn("On resource close", (Throwable)e);
            }
        }
    }

    static {
        assert (JS_FILENAME.endsWith(".js"));
        String temp = System.getProperty(ENVIRONMENT);
        if (temp == null || temp.isEmpty()) {
            temp = System.getenv(ENVIRONMENT);
            if (temp == null || temp.isEmpty()) {
                LOGGER.info("No DIRECTORY_SWAGGER defined, using default");
                DIRECTORY = null;
            } else {
                LOGGER.info("using DIRECTORY_SWAGGER (env): {}", (Object)temp);
                DIRECTORY = new File(temp);
            }
        } else {
            LOGGER.info("using DIRECTORY_SWAGGER (prop): {}", (Object)temp);
            DIRECTORY = new File(temp);
        }
        InputStream inputStream = SwaggerConfigurationSpi.class.getResourceAsStream(JS_FILENAME);
        if (inputStream == null) {
            throw new IllegalStateException("File convert.js not found");
        }
        try {
            DYNAMIC = DynamicFactoryCoupling.getByExtension((String)EXTENSION).createFrom((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn("On resource close", (Throwable)e);
            }
        }
    }
}

