/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.swagger.configuration.spi.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.swagger.configuration.spi.SwaggerConfiguration;
import net.sf.aguacate.util.codec.bridge.CodecCoupling;
import net.sf.aguacate.util.dynamic.bridge.Dynamic;
import net.sf.aguacate.util.dynamic.bridge.DynamicFactoryCoupling;
import net.sf.aguacate.util.resource.ResourceLocator;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwaggerConfigurationImpl
implements SwaggerConfiguration {
    private static final Logger LOGGER = LogManager.getFormatterLogger(SwaggerConfigurationImpl.class);
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String JS_FILENAME = "convert.js";
    private static final String EXTENSION = "js";
    private Dynamic dynamic;
    private final ResourceLocator locator;
    private final ResourceLocator aguacateLocator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwaggerConfigurationImpl(ResourceLocator aguacateLocator, ResourceLocator locator) {
        this.aguacateLocator = aguacateLocator;
        this.locator = locator;
        InputStream inputStream = SwaggerConfigurationImpl.class.getResourceAsStream(JS_FILENAME);
        if (inputStream == null) {
            throw new IllegalStateException("File convert.js not found");
        }
        try {
            this.dynamic = DynamicFactoryCoupling.getByExtension((String)EXTENSION).createFrom((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn("On resource close", (Throwable)e);
            }
        }
    }

    @Override
    public String getConfiguration(String name) {
        try {
            String swagger = this.loadSwagger(name);
            if (swagger == null) {
                return null;
            }
            String[] parameters = this.parameters(swagger);
            LOGGER.trace("before script");
            String result = (String)this.dynamic.typedExec("convert", new Object[]{swagger, parameters});
            LOGGER.trace("after script");
            return YAML_MAPPER.writeValueAsString((Object)CodecCoupling.jsonCodecBridge().decodeMap(result));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    String[] parameters(String swagger) throws IOException {
        Map conf = CodecCoupling.jsonCodecBridge().decodeMap(swagger);
        List entities = (List)conf.get("entities");
        String[] params = new String[entities.size()];
        int index = 0;
        for (String name : entities) {
            String string = this.loadConfiguration(name);
            if (string == null) {
                throw new IllegalStateException(name);
            }
            params[index] = string;
            ++index;
        }
        return params;
    }

    String toString(String filename) throws IOException {
        InputStream inputStream = this.locator.open(filename);
        if (inputStream == null) {
            throw new IllegalStateException("not found ".concat(filename));
        }
        return this.toString(inputStream);
    }

    String loadSwagger(String name) throws IOException {
        String filename = name.concat(".json");
        LOGGER.debug(filename);
        return this.load0(this.locator, filename);
    }

    String loadConfiguration(String name) throws IOException {
        String filename = name.concat(".json");
        LOGGER.debug(filename);
        return this.load0(this.aguacateLocator, filename);
    }

    String load0(ResourceLocator localLocator, String filename) throws IOException {
        InputStream inputStream = localLocator.open(filename);
        if (inputStream == null) {
            return null;
        }
        return this.toString(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toString(InputStream inputStream) throws IOException {
        try {
            String string = IOUtils.toString((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn("On resource close", (Throwable)e);
            }
        }
    }

    static {
        assert (JS_FILENAME.endsWith(".js"));
    }
}

