package net.sf.aguacate.swagger.configuration.spi;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.config.ConfigurationFactory;
import net.sf.aguacate.swagger.configuration.spi.impl.SwaggerConfigurationImpl;
import net.sf.aguacate.util.json.impl.JsonCodecImpl;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;

public class SwaggerConfigurationFactory {

	private static final Logger LOGGER = LogManager.getLogger(SwaggerConfigurationFactory.class);

	private static final String DIRECTORY = "DIRECTORY_SWAGGER";

	private static final ResourceLocator LOCATOR;

	static {
		ResourceLocator locator;
		String temp = System.getProperty(DIRECTORY);
		if (temp == null || temp.isEmpty()) {
			temp = System.getenv(DIRECTORY);
			if (temp == null || temp.isEmpty()) {
				LOGGER.info("No " + DIRECTORY + " defined, using default");
				locator = new ResourceLocatorClassImpl(SwaggerConfigurationImpl.class);
			} else {
				LOGGER.info("using " + DIRECTORY + " (env): {}", temp);
				locator = new ResourceLocatorFileImpl(temp);
			}
		} else {
			LOGGER.info("using " + DIRECTORY + " (prop): {}", temp);
			locator = new ResourceLocatorFileImpl(temp);
		}
		LOCATOR = locator;
	}

	public static SwaggerConfiguration createConfiguration() {
		return new SwaggerConfigurationImpl(ConfigurationFactory.createLocator(), LOCATOR, new JsonCodecImpl());
	}

}
