/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.swagger.configuration.spi;

import net.sf.aguacate.config.ConfigurationFactory;
import net.sf.aguacate.swagger.configuration.spi.SwaggerConfiguration;
import net.sf.aguacate.swagger.configuration.spi.impl.SwaggerConfigurationImpl;
import net.sf.aguacate.util.json.JsonCodec;
import net.sf.aguacate.util.json.impl.JsonCodecImpl;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwaggerConfigurationFactory {
    private static final Logger LOGGER;
    private static final String DIRECTORY = "DIRECTORY_SWAGGER";
    private static final ResourceLocator LOCATOR;

    public static SwaggerConfiguration createConfiguration() {
        return new SwaggerConfigurationImpl(ConfigurationFactory.createLocator(), LOCATOR, (JsonCodec)new JsonCodecImpl());
    }

    static {
        ResourceLocatorFileImpl locator;
        LOGGER = LogManager.getLogger(SwaggerConfigurationFactory.class);
        String temp = System.getProperty(DIRECTORY);
        if (temp == null || temp.isEmpty()) {
            temp = System.getenv(DIRECTORY);
            if (temp == null || temp.isEmpty()) {
                LOGGER.info("No DIRECTORY_SWAGGER defined, using default");
                locator = new ResourceLocatorClassImpl(SwaggerConfigurationImpl.class);
            } else {
                LOGGER.info("using DIRECTORY_SWAGGER (env): {}", (Object)temp);
                locator = new ResourceLocatorFileImpl(temp);
            }
        } else {
            LOGGER.info("using DIRECTORY_SWAGGER (prop): {}", (Object)temp);
            locator = new ResourceLocatorFileImpl(temp);
        }
        LOCATOR = locator;
    }
}

